package com.humuson.tms.batch.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.transaction.annotation.Transactional;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMqResend;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.AppUserRemover;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.common.model.CcsMessageId;
import com.humuson.tms.constrants.PushResponseConstants;
import com.humuson.tms.mq.model.MgsPush.PushPayload;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class PushResultServiceImpl implements PushResultService {
	
	@Autowired protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	@Autowired protected JdbcTemplate jdbcTemplate;
	@Autowired protected AppUserRemover appUserRemover;
	
	@Value("#{config['not.registed.android.immediately.update']}")
	private boolean immediatelyUpdate;
	
	@Setter private String deletePushQue;
	@Setter private String updatePushQue;
	@Setter private String insertPushQueLog;
	@Setter private String insertSelectPushQueLog;
	@Setter private String insertMqResendList;
	@Setter private String deleteMqResendList;
	@Setter private String updateMqResendList;
	
	@Setter private String insertSelectPushLogDeliver;
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.PushResultService#updateSendingStatus(java.util.List)
	 */
	@Override
	public int updateSendingStatus(PushQueue pushQueue) {
		return namedParameterJdbcTemplate.update(updatePushQue, pushQueue.toMap());
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.PushResultService#updateSendingStatus(java.util.List)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] batchUpdateSendingStatus(List<PushQueue> list) {
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(list.toArray());
		int[] result = null;
		try {
			result = namedParameterJdbcTemplate.batchUpdate(updatePushQue, params);
		} catch (Exception e) {
			log.error("batch update failed", e);
			result = null;
		}
		return result;
	}
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.PushResultService#updatePushResult(com.humuson.tms.batch.domain.PushQueue)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int updatePushQueue(PushQueue pushQueue) {
		int result = namedParameterJdbcTemplate.update(deletePushQue, pushQueue.toMap());
		
		if (result > 0) {
			result *= namedParameterJdbcTemplate.update(insertPushQueLog, pushQueue.toMap());
		}
		return result;
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.PushResultService#updatePushResult(com.humuson.tms.batch.domain.PushQueue)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] batchUpdatePushQueue(List<PushQueue> list) {
		
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(list.toArray());
		int[] result = null;
		try {
			result = namedParameterJdbcTemplate.batchUpdate(insertPushQueLog, params);
			namedParameterJdbcTemplate.batchUpdate(deletePushQue, params);
		} catch (Exception e) {
			log.error("batch update failed", e);
			result = null;
		}
		return result;
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.PushResultService#updatePushResult(com.humuson.tms.batch.domain.PushResult)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int updatePushResult(PushResult result) {
		int rtnCnt = 1;
		if (PushResponseConstants.MQ_SENDING.equals(result.getErrorCode())) {
			return rtnCnt;
		} else if (PushResponseConstants.SENDING.equals(result.getErrorCode())) {	// Private or MGS 전송중
			rtnCnt = namedParameterJdbcTemplate.update(updatePushQue, result.toMap());
		} else {		// 전송중이 아닌 경우 TMS_PUSH_QUE 테이블 삭제 및 TMS_PUSH_QUE_LOG 입력
			rtnCnt = namedParameterJdbcTemplate.update(insertPushQueLog, result.toMap());
			rtnCnt *= namedParameterJdbcTemplate.update(deletePushQue, result.toMap());
			if (PushResponseConstants.ERROR_NOT_REGISTERED.equals(result.getErrorCode())){
				if (immediatelyUpdate) {
					rtnCnt *= this.appUserRemover.updateAndroidNotRegisterToken(result.getDeviceId());
				} else {
					rtnCnt *= this.appUserRemover.insertAppRemoveDeviceList(result.getDeviceId());
				}
			}
		}
		
		return rtnCnt;
	}
	
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.PushResultService#updatePushResult(java.util.List)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public void batchUpdatePushResult(List<PushResult> resList) {
		List<PushResult> sendingList = new ArrayList<PushResult>();
		List<PushResult> completedList = new ArrayList<PushResult>();
		List<Integer> removeList = new ArrayList<Integer>();
		
		for (PushResult result : resList) {
			if (PushResponseConstants.MQ_SENDING.equals(result.getErrorCode())) {
				continue;
			} else if (PushResponseConstants.SENDING.equals(result.getErrorCode()) ||
						PushResponseConstants.SENDING_CCS.equals(result.getErrorCode())) {	
				// Private or MGS 전송중 or CCS 전송중
				sendingList.add(result);
			} else {		// 전송중이 아닌 경우 TMS_PUSH_QUE 테이블 삭제 및 TMS_PUSH_QUE_LOG 입력
				completedList.add(result);
				if (PushResponseConstants.ERROR_NOT_REGISTERED.equals(result.getErrorCode())){
					removeList.add(result.getDeviceId());
				}
			}
		}
		
		if (!sendingList.isEmpty()) {
			SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(sendingList.toArray());
			namedParameterJdbcTemplate.batchUpdate(updatePushQue, params);
		}
		
		if (!completedList.isEmpty()) {
			log.info("completedList size:{}", completedList.size());
			SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(completedList.toArray());
			namedParameterJdbcTemplate.batchUpdate(insertPushQueLog, params);
			namedParameterJdbcTemplate.batchUpdate(deletePushQue, params);
		}
		
		if (!removeList.isEmpty()) {
			// GCM ERROR CODE 2006 Not Regist User Device DelYnFlag N=>Y Update
			updateAndroidDeleteAppUser(removeList);
		}
	}

	private void updateAndroidDeleteAppUser(List<Integer> removeList) {
		log.info("not.registed.android.immediately.update : {}", immediatelyUpdate);
		if (immediatelyUpdate) {
			log.info("GCM ERROR CODE 2006 Not Regist User Device DelYnFlag N=>Y Update [ uptCnt : {} ]" ,
					removeList.size());
			try{
				this.appUserRemover.updateAndroidNotRegisterToken(removeList);
			} catch (Exception e) {
				log.error("update Android NotRegisterToken error", e);
				for(Integer deviceId : removeList){
					try {
						this.appUserRemover.updateAndroidNotRegisterToken(deviceId);
					} catch (Exception e2) {
						log.error("update Android NotRegisterToken error [deviceId:{}]", deviceId, e2);
					}
				}
			}
		} else {
			log.info("GCM ERROR CODE 2006 Not Regist User Device => Insert TMS_APP_DELETE_DEVICE_LIST  [ insertCnt : {} ]" ,
					removeList.size());
			try{
				this.appUserRemover.insertAppRemoveDeviceList(removeList);
			} catch (Exception e) {
				log.error("insert Android NotRegisterToken error", e);
				for (Integer deviceId : removeList){
					try {
						this.appUserRemover.insertAppRemoveDeviceList(deviceId);
					} catch (Exception e2) {
						log.error("insert Android NotRegisterToken error [deviceId:{}]", deviceId, e2);
					}
				}
			}
		}
	}
	
	@Transactional
	public int deleteInsertPushResult(CcsMessageId msg, String errorCode) {
		int cnt = 0;
		HashMap<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("pushId", msg.getPushId());
		paramMap.put("rtnType", "S");
		paramMap.put("errorCode", errorCode);
		paramMap.put("appOs", App.ANDROID);
		paramMap.put("chunkId", msg.getChunkId());
		paramMap.put("appGrpId", msg.getAppGrpId());
		namedParameterJdbcTemplate.update(insertSelectPushQueLog, paramMap);
		namedParameterJdbcTemplate.update(deletePushQue, paramMap);
		return cnt;
	}

	@Override
	public int batchInsertSendingStatus(List<PushPayload> privateSendList, App appInfo, String serverId) {
		ArrayList<PushMqResend> pushMqResendList = new ArrayList<PushMqResend>();
		for(PushPayload payload : privateSendList){
			PushMqResend pushMqResend = new PushMqResend();
			pushMqResend.setAppGrpKey(appInfo.getAppGrpKey());
			//pushQueue.getPushId()+"_"+pushQueue.getDeviceId()+"_"+pushQueue.getReqUid()+"_"+pushQueue.getCustId();
//			pushQueue.setPushId(Long.parseLong(payload.getId().split("&&")[0]));
			pushMqResend.setDeviceId(Long.parseLong(payload.getId().split("&&")[1]));
			pushMqResend.setReqUid(payload.getId().split("&&")[2]);
			pushMqResend.setCustId(payload.getId().split("&&")[3]);
			pushMqResend.setPushToken(payload.getToken());
			pushMqResend.setMsgUid(payload.getGcmMessage().getMsgId());
			pushMqResend.setPushTitle(payload.getGcmMessage().getPushNotiTitle());
			pushMqResend.setPushMsg(payload.getGcmMessage().getPushNotiMsg());
			pushMqResend.setMsgType(payload.getGcmMessage().getMsgType());
			pushMqResend.setPopupContent(payload.getGcmMessage().getPushRichContent());
			pushMqResend.setPushTtl(payload.getGcmMessage().getTimeToLive());
			pushMqResend.setPushImg(payload.getGcmMessage().getPushNotiImg());
			org.json.simple.JSONObject json = null;
			org.json.simple.parser.JSONParser parser = new JSONParser();
			try {
				json = (org.json.simple.JSONObject) parser.parse(payload.getGcmMessage().getPushData());
				pushMqResend.setPushKey("l");
				pushMqResend.setPushValue((String)json.get("l"));
			} catch (ParseException e) {
				log.error("pushKey/pushValue json parse error : {}",e);
				pushMqResend.setPushKey("l");
				pushMqResend.setPushValue("");
			}
			pushMqResend.setServerId(serverId);
			
			pushMqResendList.add(pushMqResend);
		}
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(pushMqResendList.toArray());
		namedParameterJdbcTemplate.batchUpdate(insertMqResendList, params);
		
		return 0;
	}
	
	@Override
	public int[] deleteMqResendList(List<Object[]> prvPushMqDeleteList){
		return jdbcTemplate.batchUpdate(deleteMqResendList, prvPushMqDeleteList);
	}

	@Override
	public int deleteMqResend(String prvPushMqDeleteTargetReqUid) {
		return jdbcTemplate.update(deleteMqResendList, prvPushMqDeleteTargetReqUid);
	}

	@Override
	public int[] updateMqResendList(List<Object[]> prvPushMqUpdateList) {
		return jdbcTemplate.batchUpdate(updateMqResendList, prvPushMqUpdateList);
	}
	
	/*
	 * XMPP deliver process
	 * */
	@Transactional
	public int insertPushDeliver(CcsMessageId msg, String errorCode,
			String resDate) {
		int cnt = 0;
		HashMap<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("pushId", msg.getPushId());
		paramMap.put("rtnType", "D");
		paramMap.put("errorCode", errorCode);
		paramMap.put("appOs", App.ANDROID);
		paramMap.put("chunkId", msg.getChunkId());
		paramMap.put("appGrpId", msg.getAppGrpId());
		
		paramMap.put("reqUid", msg.getReqUid());
		paramMap.put("custId", msg.getCustId());
		paramMap.put("deviceId", msg.getDeviceId());
		paramMap.put("resDate", resDate);
		
		cnt = namedParameterJdbcTemplate.update(insertSelectPushLogDeliver, paramMap);
		log.debug("insertSelectPushLogDeliver {}", cnt);
//		if (cnt == 0) {
//			cnt = namedParameterJdbcTemplate.update(insertSelectPushDeliver, paramMap);
//			log.info("insertSelectPushDeliver {}", cnt);
//		}
		return cnt;
	}
}
