package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushReSendSchedule;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.ScheduleService;

/**
 * @author hyogun
 *
 */

@Slf4j
public class PushReSendScheduleService implements ScheduleService<PushReSendSchedule> {
	
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	/**
	 * 
	 */
	@Setter private String selectSchedule;
	
	@Autowired private JdbcTemplate jdbcTemplate;
	
	@Autowired protected PushInfoService<App, PushMessage> pushInfoService;
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String id, boolean isRun) {
		runningScheduleMap.put(id, isRun);
	}
	

	@Override
	public List<PushReSendSchedule> getScheduleList(Object[] params) {
		List<PushReSendSchedule> list = this.jdbcTemplate.query(this.selectSchedule, 
				new RowMapper<PushReSendSchedule>() {

					@Override
					public PushReSendSchedule mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						PushReSendSchedule schedule = new PushReSendSchedule();
						schedule.setAppGrpKey(rs.getString(PushReSendSchedule.APP_GRP_KEY));
						int appGrpId = pushInfoService.getAppGrpIdByAppGrpKey(schedule.getAppGrpKey());
						schedule.setAppGrpId(appGrpId);
						schedule.setServerId(rs.getString(PushReSendSchedule.SERVER_ID));
						schedule.setSendType(rs.getString(PushReSendSchedule.SEND_TYPE));
						return schedule;
					}
			
		}, params);
		if (log.isDebugEnabled())
			log.debug("PushReSend Schedule Count:{}", list.size());
		return list;
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		return 0;
	}

	@Override
	public List<PushReSendSchedule> getScheduleList() {
		return this.getScheduleList(new Object[]{});
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}

}
