package com.humuson.tms.batch.service.impl;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.PushInfoService;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class PushInfoServiceImpl implements PushInfoService<App, PushMessage> {
	
	@Autowired protected JdbcTemplate jdbcTemplate;
	
	@Setter protected String selectPushCertInfo;
	@Setter protected String selectPushCertInfoByAppKey;
	@Setter protected String selectAppGrpIdByAppGrpKey;
	@Setter protected String selectAppGrpIdByAppKey;
	@Setter protected String selectAndroidAppKeyByAppGrpId;
	
	@Value("#{config['ios.cert.path']}")
	protected String iosCertPath;
	
	@Cacheable(value="appGrpKeyCache", key="#appGrpKey")
	@Override
	public App getAppInfo(String appGrpKey) {
		App pushAppInfo = new App();
		
		List<Map<String,Object>> pushCertList = jdbcTemplate.queryForList(selectPushCertInfo, appGrpKey);
		
		String osType = null;
		for (Map<String, Object> map : pushCertList) {
			if (log.isDebugEnabled()) log.debug("pushCert :{}", map.toString());
			
			int appId = Integer.parseInt(map.get(App.APP_ID).toString());
			int appGrpId = Integer.parseInt(map.get(App.APP_GRP_ID).toString());
			osType = map.get(App.OS).toString();
			if (App.IOS.equals(osType)) {
				String pushCert = iosCertPath.concat(File.separator).concat(map.get(App.PUSH_CERT).toString());
				pushAppInfo.setApnsPushCert(pushCert);
				pushAppInfo.setApnsPushPwd(map.get(App.PUSH_PWD).toString());
				pushAppInfo.putOs(appId, App.IOS);
				pushAppInfo.putAppKey(App.IOS, map.get(App.APP_KEY).toString());
			} else {
				pushAppInfo.setGcmApiKey(map.get(App.GCM_API_KEY1).toString());
				pushAppInfo.putOs(appId, App.ANDROID);
				pushAppInfo.putAppKey(App.ANDROID, map.get(App.APP_KEY).toString());
				pushAppInfo.setDenyAppVersion(map.get(App.DENY_APP_VER) == null ? "" : map.get(App.DENY_APP_VER).toString());
				pushAppInfo.setGcmProjectNum(Long.parseLong(map.get(App.GCM_PROJECT_NUM).toString()));
			}
			
			String privateFlag = "N";
			
			if (map.get(App.PRIVATE_FLAG) != null) {
				privateFlag = map.get(App.PRIVATE_FLAG).toString();
			}
			
			pushAppInfo.setPrivateFlag(privateFlag);
			
			if (map.get(App.PUSH_SOUND) != null) {
				pushAppInfo.setPushSound(map.get(App.PUSH_SOUND).toString());
			}
			pushAppInfo.setAppGrpId(appGrpId);
		}
		
		return pushAppInfo;
	}

	@Cacheable(value="appGrpIdByAppGrpKeyCache", key="#appGrpKey")
	@Override
	public Integer getAppGrpIdByAppGrpKey(String appGrpKey) {
		return jdbcTemplate.queryForObject(selectAppGrpIdByAppGrpKey, new Object[]{appGrpKey}, Integer.class);
	}
	

	@Cacheable(value="appGrpIdByAppKeyCache", key="#appKey")
	@Override
	public Integer getAppGrpIdByAppKey(String appKey) {
		return jdbcTemplate.queryForObject(selectAppGrpIdByAppKey, new Object[]{appKey}, Integer.class);
	}
	
	@Cacheable(value="androidAppKeyByAppGrpId", key="#appGrpId")
	@Override
	public String selectAndroidAppKeyByAppGrpId(int appGrpId) {
		
		String appKey = jdbcTemplate.queryForObject(selectAndroidAppKeyByAppGrpId, new Object[]{appGrpId}, String.class); 
		
		return appKey;
	}
	
	@Cacheable(value="appInfoByAppKeyCache", key="#appKey")
	@Override
	public App getAppInfoByAppKey(String appKey) {
		App pushAppInfo = new App();
		
		List<Map<String,Object>> pushCertList = jdbcTemplate.queryForList(selectPushCertInfoByAppKey, appKey);
		
		String osType = null;
		for (Map<String, Object> map : pushCertList) {
			if (log.isDebugEnabled()) log.debug("pushCert :{}", map.toString());
			
			int appId = Integer.parseInt(map.get(App.APP_ID).toString());
			int appGrpId = Integer.parseInt(map.get(App.APP_GRP_ID).toString());
			osType = map.get(App.OS).toString();
			if (App.IOS.equals(osType)) {
				String pushCert = iosCertPath.concat(File.separator).concat(map.get(App.PUSH_CERT).toString());
				pushAppInfo.setApnsPushCert(pushCert);
				pushAppInfo.setApnsPushPwd(map.get(App.PUSH_PWD).toString());
				pushAppInfo.putOs(appId, App.IOS);
				pushAppInfo.putAppKey(App.IOS, map.get(App.APP_KEY).toString());
			} else {
				pushAppInfo.setGcmApiKey(map.get(App.GCM_API_KEY1).toString());
				pushAppInfo.putOs(appId, App.ANDROID);
				pushAppInfo.putAppKey(App.ANDROID, map.get(App.APP_KEY).toString());
				pushAppInfo.setDenyAppVersion(map.get(App.DENY_APP_VER) == null ? "" : map.get(App.DENY_APP_VER).toString());
				pushAppInfo.setGcmProjectNum(Long.parseLong(map.get(App.GCM_PROJECT_NUM).toString()));
			}
			
			String privateFlag = "N";
			
			if (map.get(App.PRIVATE_FLAG) != null) {
				privateFlag = map.get(App.PRIVATE_FLAG).toString();
			}
			
			pushAppInfo.setPrivateFlag(privateFlag);
			
			if (map.get(App.PUSH_SOUND) != null) {
				pushAppInfo.setPushSound(map.get(App.PUSH_SOUND).toString());
			}
			pushAppInfo.setAppGrpId(appGrpId);
			pushAppInfo.setAppGrpKey(map.get(App.APP_GRP_KEY).toString());
		}
		
		return pushAppInfo;
	}
}
