package com.humuson.tms.batch.service.impl;

import java.util.List;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.batch.service.PushFeedbackService;

/**
 * 푸시 전송 결과 수집 클래스
 * @author hyogun
 *
 */
@Slf4j
public class PushFeedbackServiceImpl implements PushFeedbackService {
	
	@Autowired
	protected JdbcTemplate jdbcTemplate;
	@Setter protected String insertPushQueLog;
	@Setter protected String updatePushQue;
	@Setter protected String deletePushQue;
	@Setter protected String insertFeedback;
	@Setter protected String deleteFeedback;
	
	@Override
	public int[] insertPushQueLog(List<Object[]> params) {
		long startTime = System.currentTimeMillis();
		int[] result = jdbcTemplate.batchUpdate(this.insertPushQueLog, params);
		log.info("insertQueLog [count:{}, elapseTime:{}]", params.size(),
				System.currentTimeMillis() - startTime);
		return result;
	}
	
	@Override
	public int insertPushQueLog(Object[] params) {
		return jdbcTemplate.update(insertPushQueLog, params);
	}

	@Override
	public int[] updatePushQue(List<Object[]> params) {
		long startTime = System.currentTimeMillis();
		int[] result = jdbcTemplate.batchUpdate(this.updatePushQue, params);
		log.info("updatePushQue [count:{}, elapseTime:{}]", params.size(),
				System.currentTimeMillis() - startTime);
		return result;
	}
	
	@Override
	public int[] deletePushQue(List<Object[]> params) {
		long startTime = System.currentTimeMillis();
		int[] result = jdbcTemplate.batchUpdate(this.deletePushQue, params);
		log.info("deletePushQue [count:{}, elapseTime:{}]", params.size(),
				System.currentTimeMillis() - startTime);
		return result;
	}

	@Override
	public int[] insertFeedback(List<Object[]> params) {
		long startTime = System.currentTimeMillis();
		int[] result = jdbcTemplate.batchUpdate(this.insertFeedback, params);
		log.info("updatePushQue [count:{}, elapseTime:{}]", params.size(),
				System.currentTimeMillis() - startTime);
		return result;
	}

	@Override
	public int[] deleteFeedback(List<Object[]> params) {
		long startTime = System.currentTimeMillis();
		int[] result = jdbcTemplate.batchUpdate(this.insertFeedback, params);
		log.info("deleteFeedback [count:{}, elapseTime:{}]", params.size(),
				System.currentTimeMillis() - startTime);
		return result;
	}

	@Override
	public int updatePushQue(Object[] params) {
		return jdbcTemplate.update(updatePushQue, params);
	}
}
