package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Setter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.rainboots.datastore.DataStore;
import com.humuson.tms.batch.domain.PushFeedbackSchedule;
import com.humuson.tms.batch.service.ScheduleService;
/**
 * Private Server 전송 결과 데이터의 존재 유무를 확인하는 클래스
 *
 * @author hyogun
 *
 */
public class PushFeedbackScheduleService implements ScheduleService<PushFeedbackSchedule> {
	/**
	 * 
	 */
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	
	@Setter private String selectSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Value("#{config['use.tms.private.server']}")
	private boolean usePrivate;
	@Autowired
	private RedisTemplate<String, String> redisTemplate;
	
	@Override
	public List<PushFeedbackSchedule> getScheduleList() {
		return getScheduleList(new Object[]{});
	}
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String key, boolean isRun) {
		runningScheduleMap.put(key, isRun);
	}
	
	@Override
	public List<PushFeedbackSchedule> getScheduleList(Object[] params) {
		return this.jdbcTemplate.query(this.selectSchedule, params,
				new RowMapper<PushFeedbackSchedule>() {

			@Override
			public PushFeedbackSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
				PushFeedbackSchedule schedule = new PushFeedbackSchedule();
				int count = rs.getInt(PushFeedbackSchedule.COUNT);
				String appKey = rs.getString(PushFeedbackSchedule.APP_KEY);
				schedule.setAppGrpId(rs.getInt(PushFeedbackSchedule.APP_GRP_ID));
				schedule.setAppKey(appKey);
				if (count == 0
						&& usePrivate) {
					StringBuilder sb = new StringBuilder();
					sb.setLength(0);
					sb.append(DataStore.KEY_FEEDBACK).append(DataStore.DELIM).append(appKey);
					
					if (redisTemplate.opsForList().size(sb.toString()) > 0)
						count = 1;
				}
				schedule.setCnt(count);
				return schedule;
			}
		});
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		return 0;
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}
}
