package com.humuson.tms.batch.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.batch.service.PostIdDevideService;

@Slf4j
public class PostIdDevideServiceImpl implements PostIdDevideService {
	
	@Autowired JdbcTemplate jdbcTemplate;
	@Setter private String selectAbTestInfo, selectAbTestPostIds;
	
	@Override
	public List<Properties> getAbTestPostIds(String msgId, String postId) {
		
		Map<String, Object> abTestMap = getAbTestInfo(msgId);
		
		int abTestCount = Integer.parseInt(abTestMap.get("AB_TEST_COUNT").toString());
		double abTestRate = Double.parseDouble(abTestMap.get("AB_TEST_RATE").toString());
		
		List<Properties> abTestPostIdList = new ArrayList<Properties>();
		
		List<String> postIds = this.jdbcTemplate.queryForList(this.selectAbTestPostIds, 
				String.class, msgId, postId);
		
		for (String abPostId : postIds) {
			if (!abPostId.equals(postId)) {
				Properties properties = new Properties();
				properties.put("POST_ID", abPostId);
				properties.put("AB_TEST_RATE", String.valueOf((double)abTestRate/abTestCount));
				abTestPostIdList.add(properties);
			} 
		}
		
		Properties properties = new Properties();
		properties.put("POST_ID", postId);
		properties.put("AB_TEST_RATE", String.valueOf(100 - abTestRate));
		abTestPostIdList.add(properties);
		
		return abTestPostIdList;
	}
	
	@Override
	public Map<String,Object> getAbTestInfo(String msgId) {
		Map<String, Object> abTestMap = this.jdbcTemplate.queryForMap(selectAbTestInfo, msgId);
		log.info("AB Test info [msgId:{}, map:{}]", msgId, abTestMap.toString());
		return abTestMap;
	};
}
