package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.OptmzSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.ChannelType;

/**
 * @author hyogun
 *
 */

@Slf4j
public class OptmzManualChnTargetScheduleService implements ScheduleService<OptmzSchedule> {
	
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	/**
	 * 
	 */
	@Setter
	private String selectSchedule, updateSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String id, boolean isRun) {
		runningScheduleMap.put(id, isRun);
	}
	

	@Override
	public List<OptmzSchedule> getScheduleList(Object[] params) {
		List<OptmzSchedule> list = this.jdbcTemplate.query(this.selectSchedule, 
				new RowMapper<OptmzSchedule>() {

					@Override
					public OptmzSchedule mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						OptmzSchedule schedule = new OptmzSchedule();
						schedule.setPPostId(rs.getString(OptmzSchedule.P_POST_ID));
						schedule.setPostId(rs.getString(OptmzSchedule.POST_ID));
						schedule.setOptmzTargetType(rs.getString(OptmzSchedule.TARGET_TYPE));
						schedule.setMsgId(rs.getString(OptmzSchedule.MSG_ID));
						schedule.setJobStatus(rs.getString(OptmzSchedule.JOB_STATUS));
						schedule.setChannelType(ChannelType.valueOfCode(rs.getString(OptmzSchedule.CHN_TYPE)));
						schedule.setStepApprovalUseYn(rs.getString(OptmzSchedule.STEP_APPROVAL_USE_YN));
						schedule.setDeduplicationYn(rs.getString(OptmzSchedule.DEDUPLICATION_YN));
//						schedule.setSiteId(rs.getInt(OptmzSchedule.SITE_ID));
//						schedule.setAppGrpId(rs.getInt(OptmzSchedule.APP_GRP_ID));
						return schedule;
					}
			
		}, params);
		return list;
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		// TODO Auto-generated method stub
		int cnt = this.jdbcTemplate.update(this.updateSchedule, status, key);
		log.info("update schedule status [key:{}, status:{}, uptCnt:{}]", key, status, cnt);
		return cnt;
	}

	@Override
	public List<OptmzSchedule> getScheduleList() {
		return this.getScheduleList(new Object[]{});
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}

}
