package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.OptmzSchedule;
import com.humuson.tms.batch.domain.Schedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.ChannelType;

/**
 * @author hyogun
 *
 */
@Slf4j
public class OptmzManualChnScheduleService implements ScheduleService<OptmzSchedule> {
	
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	/**
	 * 
	 */
	@Setter
	private String selectSchedule, updateSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String id, boolean isRun) {
		runningScheduleMap.put(id, isRun);
	}
	

	@Override
	public List<OptmzSchedule> getScheduleList(Object[] params) {
		List<OptmzSchedule> list = this.jdbcTemplate.query(this.selectSchedule, 
				new RowMapper<OptmzSchedule>() {

					@Override
					public OptmzSchedule mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						OptmzSchedule schedule = new OptmzSchedule();
						schedule.setPPostId(rs.getString(OptmzSchedule.P_POST_ID));
						schedule.setPostId(rs.getString(OptmzSchedule.POST_ID));
						schedule.setOptmzTargetType(rs.getString(OptmzSchedule.TARGET_TYPE));
						schedule.setMsgId(rs.getString(OptmzSchedule.MSG_ID));
						schedule.setChannelType(ChannelType.valueOfCode(rs.getString(Schedule.CHN_TYPE)));
						return schedule;
					}
			
		});
		log.info("Optmz select schedule count : {}", list.size());
		return list;
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		int cnt = this.jdbcTemplate.update(this.updateSchedule, status, key);
		log.info("update schedule status [key:{}, status:{}, uptCnt:{}]", key, status, cnt);
		return cnt;
	}

	@Override
	public List<OptmzSchedule> getScheduleList() {
		return this.getScheduleList(new Object[]{});
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}

//	@Override
//	public String getScheduleStatus(String key) {
//		// TODO Auto-generated method stub
//		return null;
//	}
}
