package com.humuson.tms.batch.service.impl;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

import com.humuson.tms.batch.service.OptmzChannelService;
import com.humuson.tms.constrants.StatusType;

@Slf4j
public class OptmzManualChannelService implements OptmzChannelService {

	@Autowired JdbcTemplate jdbcTemplate;
	
	@Setter private String insertScheduleInfo, insertTargetServer;
	
	public void insertTargetServer(String postId, String msgId, String channelType) {
		log.info("TMS_TARGET_SERVER init [postId:{}, msgId:{}, chnType:{}]", 
				postId, msgId, channelType);
		this.jdbcTemplate.update(insertTargetServer, postId, msgId, channelType);
	}
	
	
	//@Transactional
	@Override
	public void registScheduleInfo(String postId, String msgId, String channelType,String stepApprovalUseYn) {
		
		String statusCode = "00";
		
		if("Y".equals(stepApprovalUseYn)){
			statusCode = StatusType.WAIT_APPROVAL.getCode();
		}
		
		this.jdbcTemplate.update(insertScheduleInfo, statusCode, postId, channelType);
	}

}
