package com.humuson.tms.batch.service.impl;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.jms.core.JmsTemplate;

import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.mq.model.MgsPush.Request;
import com.humuson.tms.mq.model.MgsPush.Response;

/**
 * MGS의 active mq에 public push 전송 담당 클래스
 * @author hyogun
 *
 */
public class MqJmsProducerImpl implements MqProducer {
	
	private JmsTemplate jmsTemplate;
	private String destination;

	@Override
	public void send(final Response response) {
		jmsTemplate.convertAndSend(destination, response);
	}
	
	@Override
	public void send(final Request request) {
		jmsTemplate.convertAndSend(destination, request);
	}
	
	@Override
	public void send(String destQueName, final Request request) {
		jmsTemplate.convertAndSend(destQueName, request);
	}

	@Override
	public void setJmsTemplate(JmsTemplate jmsTemplate) {
		this.jmsTemplate = jmsTemplate;
	}

	@Override
	public void setDefaultDestination(String destination) {
		this.destination = destination;
	}
	
	@Override
	public String getDefaultDestination() {
		return this.destination;
	}
	
}
