package com.humuson.tms.batch.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.MqMDP;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushSendService;
import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.PushChnType;
import com.humuson.tms.mq.model.MgsPush.Response;

import lombok.extern.slf4j.Slf4j;

/**
 * 발송요청 캠페인 MQ 로 부터 전송 처리
 * @author sgeom
 *
 */
@Slf4j
public class MqCampRequestMDP implements MqMDP<MgsPush.Request> {
//	
//	@Autowired 
//	@Qualifier(value="mqPushSendService")
//	private PushSendService<MgsPush.Request, MgsPush.Response> mqPushSendService;
	
	@Autowired protected PushInfoService<App, PushMessage> pushInfoService;

	@Autowired
	@Qualifier("mqReqProducer")
	private MqProducer mqReqProducer;
	
	@Autowired
	@Qualifier("mqCampResProducer")
	private MqProducer mqCampResProducer;
	
	@Value("#{config['use.resend.gcm.for.private.failed']}")
	private boolean useResendGcm;
	@Value("#{config['tms.private.inactive.publish']}")
	private boolean privateInactivePublish;
	
	@Value("#{config['use.mgs.public.push']}")
	protected boolean useMgsPublicPush;
	
	@Value("#{config['tms.db.enc.key']}")
	protected String encKey;
	
	@Value("#{config['sending.status.mq.response.insert']}")
	protected boolean isSendDataInsert;
	
	@Value("#{config['send.gcm.type']}")
	protected String gcmType;
	
	@Autowired
	private AutowireCapableBeanFactory beanFactory;
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.MgsMDP#handleMessage(java.lang.Object)
	 */
	@Override
	public void handleMessage(MgsPush.Request request) {
		if (log.isDebugEnabled()) {
			log.debug("requestMDP : {}", request.toString());
		}
		long startTime = System.currentTimeMillis();
		
		// appKey를 추출
		String appKey = request.getAppKey();
		
		log.debug("Request Size : {}", request.getPayloadList().size());
		
		Response response = null;
		
		boolean isAPNS = PushChnType.APNS.equals(request.getPushChnType());
		
		PushSendService<MgsPush.Request, MgsPush.Response> mqPushSendService = beanFactory.getBean(MqPushSendServiceImpl.class);
		try {
			long startTime1 = System.currentTimeMillis();
			mqPushSendService.init(pushInfoService.getAppInfoByAppKey(appKey).setReqPushChnType(request.getPushChnType()));
			log.debug("init Time1 : {}", System.currentTimeMillis() - startTime1);
//			mqPushSendService.init(pushInfoService.getAppInfo(appGrpKey));
			long t = System.currentTimeMillis();
			response = mqPushSendService.request(request, useResendGcm, privateInactivePublish);
			log.debug("send Time1 : {}", System.currentTimeMillis() - t);
			t = System.currentTimeMillis();
			mqPushSendService.close();
			log.debug("end Time1 : {} / c: {}", System.currentTimeMillis() - startTime1, System.currentTimeMillis() - t);
		} catch (Exception e) {
			log.error("Error! Push Request Send : {}" ,e );
//			log.error("ReTry Send ( Request Target insert Request Mq ) / Que Name : {} ", mqReqProducer.getDefaultDestination()  );
//			mqReqProducer.send(request);
		}
		
		try{
			long startTime2 = System.currentTimeMillis();
			if( ("XMPP".equalsIgnoreCase(gcmType) && isSendDataInsert) || isAPNS || "http".equalsIgnoreCase(gcmType)){
				mqCampResProducer.send(response);
			}
			log.debug("end Time2 : {}", System.currentTimeMillis() - startTime2);
		}catch(Exception e){
			log.error("Error! Push Response Insert Mq : {}", e);
			log.error("Error! Push Response Insert Retry / Que Name : " , mqCampResProducer.getDefaultDestination());
//			mqResProducer.send(response);
		}
		
		log.debug("end Time : {}", System.currentTimeMillis() - startTime);
	}
}
