package com.humuson.tms.batch.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.MqMDP;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushSendService;
import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.PushChnType;
import com.humuson.tms.mq.model.MgsPush.Response;

import lombok.extern.slf4j.Slf4j;

/**
 * 발송요청 자동 MQ 로 부터 전송 처리
 * @author sgeom
 *
 */
@Slf4j
public class MqAutoRequestMDP implements MqMDP<MgsPush.Request> {
	
//	private PushSendService<MgsPush.Request, MgsPush.Response> mqPushSendService;
	
	@Autowired protected PushInfoService<App, PushMessage> pushInfoService;
	
	@Autowired
	@Qualifier("mqReqProducer")
	private MqProducer mqReqProducer;
	
	@Autowired
	@Qualifier("mqAutoResProducer")
	private MqProducer mqAutoResProducer;
	
	@Value("#{config['use.resend.gcm.for.private.failed']}")
	private boolean useResendGcm;
	@Value("#{config['tms.private.inactive.publish']}")
	private boolean privateInactivePublish;
	
	@Value("#{config['sending.status.mq.response.insert']}")
	protected boolean isSendDataInsert;
	
	@Value("#{config['send.gcm.type']}")
	protected String gcmType;
	
	@Autowired
	private AutowireCapableBeanFactory beanFactory;
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.MgsMDP#handleMessage(java.lang.Object)
	 */
	@Override
	public void handleMessage(MgsPush.Request request) {
		if (log.isDebugEnabled()) {
			log.debug("requestMDP : {}", request.toString());
		}
		
		// appKey를 세팅
		String appKey = request.getAppKey();
		
		boolean isAPNS = PushChnType.APNS.equals(request.getPushChnType());
		
		Response response = null;
		PushSendService<MgsPush.Request, MgsPush.Response> mqPushSendService = beanFactory.getBean(MqPushSendServiceImpl.class);
		try {
			mqPushSendService.init(pushInfoService.getAppInfoByAppKey(appKey).setReqPushChnType(request.getPushChnType()));
//			mqPushSendService.init(pushInfoService.getAppInfo(appGrpKey));
			response = mqPushSendService.request(request, useResendGcm, privateInactivePublish);
		} catch (Exception e) {
			log.error("Error! Push Request Send : {}" ,e );
//			log.error("ReTry Send ( Request Target insert Request Mq ) / Que Name : {} ", mqReqProducer.getDefaultDestination()  );
//			mqReqProducer.send(request);
		} finally {
			try {
				mqPushSendService.close();
			} catch (Exception e2) {
				// TODO: handle exception
			}
		}
		
		try{
			if( ("XMPP".equalsIgnoreCase(gcmType) && isSendDataInsert) || isAPNS || "http".equalsIgnoreCase(gcmType) ){
				if (log.isDebugEnabled()) {
					log.debug("RESPONSE : {}", response.toString());
				}
//				mqAutoResProducer.send(response);
			}
		}catch(Exception e){
			log.error("Error! Push Response Insert Mq : {}", e);
			log.error("Error! Push Response Insert Retry / Que Name : " , mqAutoResProducer.getDefaultDestination());
//			mqResProducer.send(response);
		}
		
		
	}
}
