package com.humuson.tms.batch.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.MqMDP;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.PushChnType;

import lombok.extern.slf4j.Slf4j;

/**
 * MGS로 부터 전송 결과를 DB에 반영
 * @author hyogun
 *
 */
@Slf4j
public class MgsResponseMDP implements MqMDP<MgsPush.Response> {
	
	@Autowired private PushResultService pushResultService;
	@Autowired protected PushInfoService<App, PushMessage> pushInfoService;
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.MgsMDP#handleMessage(java.lang.Object)
	 */
	@Override
	public void handleMessage(MgsPush.Response response) {
		if (log.isDebugEnabled()) {
			log.debug("resonseMDP : {}", response.toString());
		}
		List<MgsPush.Response.ResponsePayload> list = response.getResPayloadList();
		App app = pushInfoService.getAppInfoByAppKey(response.getAppKey());
		
		List<PushResult> resList = new ArrayList<PushResult>();
		
		String os = App.ANDROID;
	   if (response.getPushChnType() == PushChnType.APNS) {
			   	os = App.IOS;
	   }
		
		for (MgsPush.Response.ResponsePayload resPayload : list) {
			resList.add(
					new PushResult(app.getAppGrpId(), String.valueOf(resPayload.getReturnCode().getNumber()), 
							resPayload.getId(), os, null)
					);
		}
		
		pushResultService.batchUpdatePushResult(resList);
	}
}
