package com.humuson.tms.batch.service.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.Response;

import lombok.extern.slf4j.Slf4j;

/**
 * MGS와 JMS 통신시 사용되는 객체변환 담당
 * @author hyogun
 *
 */
@Slf4j
public class MgsResponseConverterImpl extends MgsPushMessageConvert<MgsPush.Response> {
	
	@Override
	protected Response parseByteMessage(byte[] bytes) {
		try {
			return MgsPush.Response.parseFrom(bytes);
		} catch (InvalidProtocolBufferException e) {
			log.error("MgsPush.Response parse error", e);
			return null;
		}
	}
}
