package com.humuson.tms.batch.service.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.Request;

import lombok.extern.slf4j.Slf4j;

/**
 * MGS와 JMS 통신시 사용되는 객체변환 담당
 * @author hyogun
 *
 */
@Slf4j
public class MgsRequestConverterImpl extends MgsPushMessageConvert<MgsPush.Request> {
	
	@Override
	protected Request parseByteMessage(byte[] bytes) {
		try {
			return MgsPush.Request.parseFrom(bytes);
		} catch (InvalidProtocolBufferException e) {
			log.error("MgsPush.Request parse error", e);
			return null;
		}
	}
}
