package com.humuson.tms.batch.service.impl;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

import com.humuson.tms.mq.model.MgsPush;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 * @param <T>
 */
@Slf4j
public abstract class MgsPushMessageConvert<T> implements MessageConverter {

	/**
	 * JMS Send Object convert
	 * @param object
	 * @param session
	 * @return
	 * @throws JMSException
	 * @throws MessageConversionException
	 */
	@Override
	public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
		BytesMessage byteMessage = session.createBytesMessage();
		
		if (object instanceof MgsPush.Request) {
			byteMessage.writeBytes(((MgsPush.Request) object).toByteArray());
		} else if (object instanceof MgsPush.Response) {
			byteMessage.writeBytes(((MgsPush.Response) object).toByteArray());
		} else if (object instanceof MgsPush.ApnsFeedback) {
			byteMessage.writeBytes(((MgsPush.ApnsFeedback) object).toByteArray());
		}
		
		return byteMessage;
	}
	
	/**
	 * JMS Receive Object Convert
	 * @param message
	 * @return
	 * @throws JMSException
	 * @throws MessageConversionException
	 */
	@Override
	public Object fromMessage(Message message) throws JMSException, MessageConversionException {
		if (!(message instanceof BytesMessage)) {
			log.error("messaget convert error");
			throw new MessageConversionException("not MapMessage");
		}
		
		T t = null;
		
		if (message instanceof BytesMessage) {
			BytesMessage byteMessage = (BytesMessage) message;
			byte[] data = new byte[(int) byteMessage.getBodyLength()];
			byteMessage.readBytes(data);
			try {
				t = this.parseByteMessage(data);
			} catch (Exception e) {
				log.error("MgsPush parse error", e);
			}
		}
		return t;
	}
	
	protected abstract T parseByteMessage(byte[] bytes);
}
