package com.humuson.tms.batch.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.ApnsFeedback;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.AppUserRemover;
import com.humuson.tms.batch.service.MqMDP;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.mq.model.MgsPush;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class MgsApnsFeedbackMDP implements MqMDP<MgsPush.ApnsFeedback> {
	
	@Autowired private PushInfoService<App, PushMessage> pushInfoServiceImpl;
	@Autowired protected AppUserRemover appUserRemover;
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.MgsMDP#handleMessage(java.lang.Object)
	 */
	@Override
	public void handleMessage(MgsPush.ApnsFeedback feedback) {
		if (log.isDebugEnabled()) {
			log.debug("response :{}", feedback.toString());
		}
		String appKey = feedback.getAppKey();
		
		int appGrpId = pushInfoServiceImpl.getAppGrpIdByAppKey(appKey);
		List<String> removedTokenList = feedback.getTokenList();
		
		List<ApnsFeedback> apnsFeedbackList = new ArrayList<ApnsFeedback>();
		for (String token : removedTokenList) {
			apnsFeedbackList.add(new ApnsFeedback(appGrpId, token));
		}
		try {
			appUserRemover.updateIosUnActiveToken(apnsFeedbackList);
		} catch (Exception e) {
			log.error("apns Feedback update error [{}]", e);
			for (ApnsFeedback apnsFeedback : apnsFeedbackList) {
				try {
					appUserRemover.updateIosUnActiveToken(apnsFeedback);
				} catch (Exception e2) {
					log.error("apns Feedback update error [appGrpId:{}, uuid:{}, msg:{}]",
							apnsFeedback.getGrpId(), apnsFeedback.getUuid(), e.getMessage());
				}
			}
		}
		
	}
}
