package com.humuson.tms.batch.service.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.humuson.tms.mq.model.MgsPush;

import lombok.extern.slf4j.Slf4j;

/**
 * MGS와 JMS 통신시 사용되는 객체변환 담당
 * @author hyogun
 *
 */
@Slf4j
public class MgsApnsFeedbackConverterImpl extends MgsPushMessageConvert<MgsPush.ApnsFeedback> {
	
	@Override
	protected MgsPush.ApnsFeedback parseByteMessage(byte[] bytes) {
		try {
			return MgsPush.ApnsFeedback.parseFrom(bytes);
		} catch (InvalidProtocolBufferException e) {
			log.error("MgsPush.ApnsFeedback parse error", e);
			return null;
		}
	}

}
