package com.humuson.tms.batch.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import org.jivesoftware.smack.SmackException.NotConnectedException;
import org.jivesoftware.smack.packet.Stanza;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import com.google.android.gcm.ccs.server.CcsConnectionManager;
import com.google.android.gcm.ccs.server.GcmPacketExtension;
import com.google.android.gcm.ccs.server.XMPPGCMConnection;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.common.model.mq.PushSendType;
import com.humuson.tms.common.util.PushCcsMessageIdUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.PushPayload;
import com.humuson.tms.mq.model.MgsPush;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class GcmCcsService {

	@Autowired
	private CcsConnectionManager ccsConnectionManager;
	
	private long projectId;
	private String strProjectId;
	private String apiKey;	
	private int hitCount;
	Random rnd = new Random();
	
	@Value("#{config['xmpp.sending.size']}")
	private int resetPeriod;
	
	@Value("#{config['xmpp.connection.size']}")
	private int maxConnection;
	
	@Value("#{config['xmpp.upstream.use.flag']}")
	private boolean upstreamUseFlag;
	
    private XMPPGCMConnection connection;

    /**
     * Indicates whether the connection is in draining state, which means that it
     * will not accept any new downstream messages.
     */
    protected volatile boolean connectionDraining = false;
    
    public GcmCcsService(){    	
    	log.debug("GcmCcsService Create!!");
    }
    
    /**
     *  CcsConnectionManager에 생성된 해당 apiKey의 커넥션을 리턴.
     *  생성되어 있지 않는 경우 Connection 생성 후 리턴     
     */
    public void init(long projectId, String apiKey){
    	strProjectId = String.valueOf(projectId);
    	setProjectId(projectId);
    	setApiKey(apiKey);
    	connection = ccsConnectionManager.getConnection(projectId, apiKey);    	
    }
    
    /**
     * 다음 커넥션 return     
     */
    public void reset(){
    	connection = ccsConnectionManager.getConnection(getProjectId(), getApiKey());
    }
    
    /**
     * 커넥션 주기 카운트를 확인 한 후 임계치 도달한 경우 다음 커넥션으로 리셋     
     */    
    public synchronized void checkHitCnt(){
    	int cnt = getHitCount();
    	
    	if (cnt >= resetPeriod){
    		setHitCount(0);    		
    		reset();
    		
    		log.debug("CCS Connection Reset!!");
    	}else {
    		setHitCount(++cnt);    		
//    		logger.info("Hit Count : {}", getHitCount());
    	}
    }

    /**
     * Sends a downstream message to GCM.
     *
     * @return true if the message has been successfully sent.
     */
    public boolean sendDownstreamMessage(String jsonRequest) throws
    	NotConnectedException {
        if (!connection.isDrainning() && connection.isConnected()) {
            send(jsonRequest);
            return true;
        }else{
        	for(int i=0; i<maxConnection; i++){
        		reset();
        		if(!connection.isDrainning() && connection.isConnected()){
        			break;
        		}
        	}
        	send(jsonRequest);
        }
        log.info("Dropping downstream message since the connection is draining");
        return false;
    }

    /**
     * Sends a packet with contents provided.
     */
    protected void send(String jsonRequest) throws NotConnectedException {
    	checkHitCnt();

    	Stanza request = new GcmPacketExtension(jsonRequest).toPacket();
    	request.setTo(strProjectId);
    	connection.sendStanza(request);
    }
    
    protected void sendTest(String jsonRequest) throws NotConnectedException {
    	
    	Stanza request = new GcmPacketExtension(jsonRequest).toPacket();
    	connection.sendStanza(request);
    }

    /**
     * Handles an upstream data message from a device application.
     *
     * <p>This sample echo server sends an echo message back to the device.
     * Subclasses should override this method to properly process upstream messages.
     */
    protected void handleUpstreamMessage(Map<String, Object> jsonObject) {
        // PackageName of the application that sent this message.
        /*String category = (String) jsonObject.get("category");
        String from = (String) jsonObject.get("from");
        @SuppressWarnings("unchecked")
        Map<String, String> payload = (Map<String, String>) jsonObject.get("data");
        payload.put("ECHO", "Application: " + category);

        // Send an ECHO response back
        String echo = createJsonMessage(from, nextMessageId(), payload,
                "echo:CollapseKey", -1, false);
        
        System.out.println(echo);

        try {
            sendDownstreamMessage(echo);
        } catch (NotConnectedException e) {
            logger.log(Level.WARNING, "Not connected anymore, echo message is not sent", e);
        }*/
    }
   
    /**
     * Creates a JSON encoded GCM message.
     *
     * @param to RegistrationId of the target device (Required).
     * @param messageId Unique messageId for which CCS will send an
     *         "ack/nack" (Required).
     * @param payload Message content intended for the application. (Optional).
     * @param collapseKey GCM collapse_key parameter (Optional).
     * @param timeToLive GCM time_to_live parameter (Optional).
     * @param delayWhileIdle GCM delay_while_idle parameter (Optional).
     * @return JSON encoded GCM message.
     */
/*    public static String createJsonMessage(String to, String messageId,
            Map<String, String> payload, String collapseKey, int timeToLive,
            Boolean delayWhileIdle) {
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("to", to);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive < 0) {
            message.put("time_to_live", timeToLive);
        }
        if (delayWhileIdle != null && delayWhileIdle) {
            message.put("delay_while_idle", true);
        }
      message.put("message_id", messageId);
      message.put("data", payload);
//      message.put("delivery_receipt_requested", true);
      return JSONValue.toJSONString(message);
    }*/

    /**
     * Creates a JSON encoded ACK message for an upstream message received
     * from an application.
     *
     * @param to RegistrationId of the device who sent the upstream message.
     * @param messageId messageId of the upstream message to be acknowledged to CCS.
     * @return JSON encoded ack.
     */
    protected static String createJsonAck(String to, String messageId) {
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("message_type", "ack");
        message.put("to", to);
        message.put("message_id", messageId);
        return JSONValue.toJSONString(message);
    }



    public static void main(String[] args) throws Exception {
        final long senderId = 997255892867L; // your GCM sender id
        final String password = "AIzaSyBROhTcnB_9eSYqAjGwCc1s82T3UfngCZ8";

//        final long senderId = 470843232409L; // your GCM sender id
//        final String password = "AIzaSyBzYSrH589O_RYwY-JBcI0DK4TisYfIEF0";
        

        CcsConnectionManager ccsConnectionManager = new CcsConnectionManager();
        GcmCcsService ccsClient = new GcmCcsService();
        
//        ccsClient.connection = ccsConnectionManager.connectTest(senderId, password);

        // Send a sample hello downstream message to a device.
//        String toRegId = "APA91bEhDG1QMkvYFA7KTTU-gkosKeWoGJlY46kYQpLLGL-XRsnwhaOI_ctlleX41xjB3Ia9Ww-UAaHrgf5UsLVPBHEZglObRutLQrvCMsoGhxuYVGScv_g";
        //String toRegId = "APA91bE3SQc7AczuYTls7wSRRU8NobVETmb-FIFOBvG8zvu6m1Y_rVgIVWqy5MM8xFcJbhkjWk2OmhoSe7mCliY8l_R4JfavHJZEfDuIA_KgeZeynrweVQ8";
        
//        String toRegId = "APA91bE0pXcsY7UeB6zKvyXmwKUFLjIcv3Kz8FVqr-AILaeLW4KxxXeSBG5w6j_qB1GBDqww_0M5OQ4Io27IrtvrmoELDHdEb1aEe7VUF1qfhYDoHqX7omc"; 
        //g2
        String toRegId = "APA91bFiCylyZWeFV1yQmSL2e6F5PCJUf7BkUuaTvN4dRkcPZ5q38I3eneXzvoBrnrh3q-KaUMKe2hDsB_jUKO7h6aqmBNSXLlp5yK7pvrpH3z11ayt1PLc";
        
        String messageId = "1602181428";
        Map<String, String> payload = new HashMap<String, String>();
        payload.put(PushPayload.PUSH_NOTI_MSG, "test");
        payload.put(PushPayload.PUSH_NOTI_TITLE, "Test Message");
        payload.put(PushPayload.PUSH_NOTI_IMG, "");
        payload.put(PushPayload.PUSH_RICH_CONTENT, "");
        payload.put(PushPayload.MSG_TYPE, "T");
        payload.put(PushPayload.MSG_ID, messageId);
        
        JSONObject json = new JSONObject();		
		json.put("l", "");		
		
		payload.put(PushPayload.PUSH_DATA, json.toString());
		payload.put(PushPayload.PUSH_SOUND, "default");
		
        String collapseKey = null;
        int timeToLive = -1;
        
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        
//        message.put("delay_while_idle", true);
        message.put("message_id", messageId);
        message.put("data", payload);
//      message.put("delivery_receipt_requested", true);
        
        try {
        	ccsClient.sendTest(JSONValue.toJSONString(message));
        	
        	Thread.sleep(60*1000);        	
        	
        	System.out.println("TEST END");
        } catch (Exception e) {
        	e.printStackTrace();
        }
    }
    
	public long getProjectId() {
		return projectId;
	}

	public void setProjectId(long projectId) {
		this.projectId = projectId;
	}

	public String getApiKey() {
		return apiKey;
	}

	public void setApiKey(String apiKey) {
		this.apiKey = apiKey;
	}
	
	public int getHitCount() {
		return hitCount;
	}

	public void setHitCount(int hitCount) {
		this.hitCount = hitCount;
	}
	
	public String makeCcsMessage(PushQueue pushQueue, PushMessage pushMessage, int appGrpId) {
		
        
		String toRegId = pushQueue.getPushToken();        
        
		long pushId = pushQueue.getPushId();
		String chunkId = pushQueue.getChunkId();
        
        
        Map<String, String> payload = new HashMap<String, String>();
        
        payload.put(PushPayload.PUSH_NOTI_MSG, pushMessage.getPushMsg());
        payload.put(PushPayload.PUSH_NOTI_TITLE, pushMessage.getPushTitle() == null ? "": pushMessage.getPushTitle());
        
		// rich content의 경우 header 에 meta tag를 추가해줌
//		StringBuilder richContentBuf = new StringBuilder();
//		
//		if ("H".equals(msgType)
//				&& !StringUtils.isEmpty(richContent)) {
//			
//			String richHeadBefore = richContent.substring(0, richContent.indexOf(HEAD)+ HEAD.length());
//			richContentBuf.append(richHeadBefore).append("\n");
//			richContentBuf.append(richCharsetHeader);
//			richContentBuf.append("\n");
//			richContentBuf.append(richMsgIdHeader.replace(MAPPING_MSG_ID_KEYWORD, String.valueOf(msgId)));
//			richContentBuf.append("\n");
//			richContentBuf.append(richPushTypeHeader);
//
//			String richHeadAfter = richContent.substring(richContent.indexOf(HEAD) + HEAD.length(),
//					richContent.length());
//			
//			richContentBuf.append(richHeadAfter);
//			if (log.isDebugEnabled())
//				log.debug("makeGcmMessage richContentBuf : {}", richContentBuf.toString());
//		}
        
        String pushImage = pushMessage.getPushImg();
        if (pushImage != null 
				&& (!pushImage.startsWith("http://"))
				&& "http://".length() >= pushImage.length()) {
			pushImage = "";
		}
		
        payload.put(PushPayload.PUSH_NOTI_IMG, pushImage);
        payload.put(PushPayload.PUSH_RICH_CONTENT, pushMessage.getPopupContent());
        payload.put(PushPayload.MSG_TYPE, pushMessage.getMsgType());
        payload.put(PushPayload.MSG_ID, String.valueOf(pushMessage.getMsgUid()));
        
        JSONObject json = new JSONObject();
		
        
        String key = pushMessage.getPushKey();
        String value = pushMessage.getPushValue();
        
		if (!StringUtils.isEmpty(key)) {
			json.put(key, value == null ? "" : value);
		}
		
		payload.put(PushPayload.PUSH_DATA, json.toString());
		
		// GCM 발송시 푸시 사운드 필요 여부를 모르겠음. 주석처리.
//		if (!StringUtils.isEmpty(appInfo.getPushSound())) {
//			payload.put(PushPayload.PUSH_SOUND, appInfo.getPushSound());
//		} else {
//			payload.put(PushPayload.PUSH_SOUND, "default");
//		}
		
//		UA 설정과 동일하게 셋팅
//        String collapseKey = String.valueOf(msgId).hashCode()+"";
        String collapseKey = null;
        int timeToLive = -1;
        
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        message.put("delay_while_idle", false);
        long deviceId = pushQueue.getDeviceId();
        
        
        message.put("message_id", PushCcsMessageIdUtil.makeCcsMessageId(pushId, deviceId, pushQueue.getReqUid(), pushQueue.getCustId(),appGrpId,pushQueue.getServerId(), PushSendType.TB));
        message.put("data", payload);
      //[upstream]
        if(upstreamUseFlag) message.put("delivery_receipt_requested", true);
        else message.put("delivery_receipt_requested", false);
        
        return JSONValue.toJSONString(message);
	}
	
public String makeCcsMessage(PushQueue pushQueue, PushMessage pushMessage, int appGrpId, PushSendType pushSendType) {
		
        
		String toRegId = pushQueue.getPushToken();        
        
		long pushId = pushQueue.getPushId();
		String chunkId = pushQueue.getChunkId();
        
        
        Map<String, String> payload = new HashMap<String, String>();
        
        payload.put(PushPayload.PUSH_NOTI_MSG, pushMessage.getPushMsg());
        payload.put(PushPayload.PUSH_NOTI_TITLE, pushMessage.getPushTitle() == null ? "": pushMessage.getPushTitle());
        
		// rich content의 경우 header 에 meta tag를 추가해줌
//		StringBuilder richContentBuf = new StringBuilder();
//		
//		if ("H".equals(msgType)
//				&& !StringUtils.isEmpty(richContent)) {
//			
//			String richHeadBefore = richContent.substring(0, richContent.indexOf(HEAD)+ HEAD.length());
//			richContentBuf.append(richHeadBefore).append("\n");
//			richContentBuf.append(richCharsetHeader);
//			richContentBuf.append("\n");
//			richContentBuf.append(richMsgIdHeader.replace(MAPPING_MSG_ID_KEYWORD, String.valueOf(msgId)));
//			richContentBuf.append("\n");
//			richContentBuf.append(richPushTypeHeader);
//
//			String richHeadAfter = richContent.substring(richContent.indexOf(HEAD) + HEAD.length(),
//					richContent.length());
//			
//			richContentBuf.append(richHeadAfter);
//			if (log.isDebugEnabled())
//				log.debug("makeGcmMessage richContentBuf : {}", richContentBuf.toString());
//		}
        
        String pushImage = pushMessage.getPushImg();
        if (pushImage != null 
				&& (!pushImage.startsWith("http://"))
				&& "http://".length() >= pushImage.length()) {
			pushImage = "";
		}
		
        payload.put(PushPayload.PUSH_NOTI_IMG, pushImage);
        payload.put(PushPayload.PUSH_RICH_CONTENT, pushMessage.getPopupContent());
        payload.put(PushPayload.MSG_TYPE, pushMessage.getMsgType());
        payload.put(PushPayload.MSG_ID, String.valueOf(pushMessage.getMsgUid()));
        
        JSONObject json = new JSONObject();
		
        
        String key = pushMessage.getPushKey();
        String value = pushMessage.getPushValue();
        
		if (!StringUtils.isEmpty(key)) {
			json.put(key, value == null ? "" : value);
		}
		
		payload.put(PushPayload.PUSH_DATA, json.toString());
		
		// GCM 발송시 푸시 사운드 필요 여부를 모르겠음. 주석처리.
//		if (!StringUtils.isEmpty(appInfo.getPushSound())) {
//			payload.put(PushPayload.PUSH_SOUND, appInfo.getPushSound());
//		} else {
//			payload.put(PushPayload.PUSH_SOUND, "default");
//		}
		
//		UA 설정과 동일하게 셋팅
//        String collapseKey = String.valueOf(msgId).hashCode()+"";
        String collapseKey = null;
        int timeToLive = -1;
        
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        message.put("delay_while_idle", false);
        long deviceId = pushQueue.getDeviceId();
        
        if(PushSendType.TB.equals(pushSendType)){
        	message.put("message_id", PushCcsMessageIdUtil.makeCcsMessageId(pushId, deviceId, pushQueue.getReqUid(), pushQueue.getCustId(),appGrpId,pushQueue.getServerId(), pushSendType));
        }else if(PushSendType.MQ.equals(pushSendType)){
        	StringBuffer sb = new StringBuffer();
    		sb.append("PUSH_ID_VALUE")
    			.append("&&").append(String.valueOf(deviceId))
    			.append("&&").append(pushQueue.getReqUid())
    			.append("&&").append(pushQueue.getCustId());
    		message.put("message_id",PushCcsMessageIdUtil.makeCcsMessageId(sb.toString(),appGrpId,pushQueue.getServerId(), pushSendType));
        }
        message.put("data", payload);
      //[upstream]
        if(upstreamUseFlag) message.put("delivery_receipt_requested", true);
        else message.put("delivery_receipt_requested", false);
        
        return JSONValue.toJSONString(message);
	}
	
	public String makeCcsMessage(MgsPush.PushPayload pushPayload, int appGrpId, String serverId) {
		
        
		String toRegId = pushPayload.getToken();   
        
//		long pushId = pushQueue.getPushId();
//		String chunkId = pushQueue.getChunkId();
        
        
        Map<String, String> payload = new HashMap<String, String>();
        
        payload.put(PushPayload.PUSH_NOTI_MSG, pushPayload.getGcmMessage().getPushNotiMsg());
        payload.put(PushPayload.PUSH_NOTI_TITLE, pushPayload.getGcmMessage().getPushNotiTitle());
        
		// rich content의 경우 header 에 meta tag를 추가해줌
//		StringBuilder richContentBuf = new StringBuilder();
//		
//		if ("H".equals(msgType)
//				&& !StringUtils.isEmpty(richContent)) {
//			
//			String richHeadBefore = richContent.substring(0, richContent.indexOf(HEAD)+ HEAD.length());
//			richContentBuf.append(richHeadBefore).append("\n");
//			richContentBuf.append(richCharsetHeader);
//			richContentBuf.append("\n");
//			richContentBuf.append(richMsgIdHeader.replace(MAPPING_MSG_ID_KEYWORD, String.valueOf(msgId)));
//			richContentBuf.append("\n");
//			richContentBuf.append(richPushTypeHeader);
//
//			String richHeadAfter = richContent.substring(richContent.indexOf(HEAD) + HEAD.length(),
//					richContent.length());
//			
//			richContentBuf.append(richHeadAfter);
//			if (log.isDebugEnabled())
//				log.debug("makeGcmMessage richContentBuf : {}", richContentBuf.toString());
//		}
        
        String pushImage = pushPayload.getGcmMessage().getPushNotiImg();
        if (pushImage != null 
				&& (!pushImage.startsWith("http://"))
				&& "http://".length() >= pushImage.length()) {
			pushImage = "";
		}
		
        payload.put(PushPayload.PUSH_NOTI_IMG, pushImage);
        payload.put(PushPayload.PUSH_RICH_CONTENT, pushPayload.getGcmMessage().getPushRichContent());
        payload.put(PushPayload.MSG_TYPE, pushPayload.getGcmMessage().getMsgType());
        payload.put(PushPayload.MSG_ID, String.valueOf(pushPayload.getGcmMessage().getMsgId()));
        
        JSONObject json = new JSONObject();
		
        
//        String key = pushPayload.getGcmMessage().getPush.getPushKey();
//        String value = pushMessage.getPushValue();
//        
//		if (!StringUtils.isEmpty(key)) {
//			json.put(key, value == null ? "" : value);
//		}
		
		payload.put(PushPayload.PUSH_DATA, pushPayload.getGcmMessage().getPushData());
		
		// GCM 발송시 푸시 사운드 필요 여부를 모르겠음. 주석처리.
//		if (!StringUtils.isEmpty(appInfo.getPushSound())) {
//			payload.put(PushPayload.PUSH_SOUND, appInfo.getPushSound());
//		} else {
//			payload.put(PushPayload.PUSH_SOUND, "default");
//		}
		
//		UA 설정과 동일하게 셋팅
//        String collapseKey = String.valueOf(msgId).hashCode()+"";
        String collapseKey = null;
        int timeToLive = -1;
        
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        message.put("delay_while_idle", false);
//        long deviceId = pushQueue.getDeviceId();
        
        message.put("message_id", PushCcsMessageIdUtil.makeCcsMessageId(pushPayload.getId(), appGrpId, serverId, PushSendType.MQ));
        message.put("data", payload);
        //[upstream]
        if(upstreamUseFlag) message.put("delivery_receipt_requested", true);
        else message.put("delivery_receipt_requested", false);
        
        return JSONValue.toJSONString(message);
	}
 
}
