package com.humuson.tms.batch.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.domain.Schedule;
import com.humuson.tms.batch.service.ScheduleStatusUpdateService;
import com.humuson.tms.constrants.CommonType;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 * @see 대량/자동 스케쥴 테이블에 피로도 관련 JOB_STATUS 업데이트 처리
 *
 */
@Slf4j
public class FatigueFilterScheduleStatusUpdateService implements ScheduleStatusUpdateService {
	
	private static final String UNDER_BAR = "_";
	
	private String updateSchdJobStatusSql;
	
	@Setter private String updateCampSchdJobStatusSql;
	@Setter private String updateAutoSchdJobStatusSql;
	
	@Autowired private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	
	@Override
	public int updateSchdlStatus(Schedule schedule) {
		
		log.debug("updateSchdlStatus()... Schedule: {}", schedule);
		
		if (schedule instanceof FatigueFilterSchedule) {
			FatigueFilterSchedule target = ((FatigueFilterSchedule) schedule);
			
			String sendType = target.getSendType();
			
			if (CommonType.MASS.getCode().equals(sendType)) {
				
				updateSchdJobStatusSql = updateCampSchdJobStatusSql;
			} else if (CommonType.AUTO.getCode().equals(sendType)) {
				
				String[] postId = target.getPostId().split(UNDER_BAR);
				if (postId.length < 2) return -1;	// POST_ID가 WORKDAY_SEQ 형태로 되어 있지 않다면 패스
				
				target.setWorkday(postId[0]);
				
				String seqno = postId[1];
				try {
					target.setSeqno(Integer.parseInt(seqno));
				} catch(Exception e) {
					log.error("updateSchdlStatus()... Wrong SEQNO: [ " + seqno + " ] !", e);
					return -1;
				}
				
				updateSchdJobStatusSql = updateAutoSchdJobStatusSql;
			} else {
				log.error("updateSchdlStatus()... Wrong SEND_TYPE!. SendType: {}", sendType);
				return -1;
			}
			
			log.debug("updateSchdlStatus()... Target: {}", target);
			
			return namedParameterJdbcTemplate.update(updateSchdJobStatusSql, new BeanPropertySqlParameterSource(target));	
		}
		return -1;
	}
}
