package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.ChannelType;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class FatigueFilterScheduleService implements ScheduleService<FatigueFilterSchedule> {
	
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	
	@Setter private String selectSchedule;
	@Setter private String updateSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String id, boolean isRun) {
		runningScheduleMap.put(id, isRun);
	}
	
	@Override
	public List<FatigueFilterSchedule> getScheduleList(Object[] params) {
		List<FatigueFilterSchedule> list = this.jdbcTemplate.query(this.selectSchedule, 
				new RowMapper<FatigueFilterSchedule>() {

					@Override
					public FatigueFilterSchedule mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						
						FatigueFilterSchedule schedule = new FatigueFilterSchedule();
						
						schedule.setSendType(rs.getString(FatigueFilterSchedule.SEND_TYPE));
						schedule.setPostId(rs.getString(FatigueFilterSchedule.POST_ID));
						schedule.setServerId(rs.getString(FatigueFilterSchedule.SERVER_ID));
						schedule.setSiteId(rs.getInt(FatigueFilterSchedule.SITE_ID));
						schedule.setWorkday(rs.getString(FatigueFilterSchedule.WORKDAY));
						schedule.setChannelType(ChannelType.valueOfCode(rs.getString(FatigueFilterSchedule.CHN_TYPE)));
						schedule.setListTable(rs.getString(FatigueFilterSchedule.LIST_TABLE));
						
						return schedule;
					}
		}, params);
		
		log.debug("getScheduleList()...  Result List: {}", list);

		return list;
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		return 0;
	}

	@Override
	public List<FatigueFilterSchedule> getScheduleList() {
		return this.getScheduleList(new Object[]{});
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}

}
