package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.ApnsFeedbackSchedule;
import com.humuson.tms.batch.domain.DirectPushSendSchedule;
import com.humuson.tms.batch.service.ScheduleService;

import lombok.Setter;
/**
 *
 * @author hyogun
 *
 */
public class DirectPushSendScheduleService implements ScheduleService<DirectPushSendSchedule> {
	/**
	 * 
	 */
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	
	@Setter private String selectSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public List<DirectPushSendSchedule> getScheduleList() {
		return getScheduleList(new Object[]{});
	}
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String key, boolean isRun) {
		runningScheduleMap.put(key, isRun);
	}
	
	@Override
	public List<DirectPushSendSchedule> getScheduleList(Object[] params) {
		return this.jdbcTemplate.query(this.selectSchedule, params,
				new RowMapper<DirectPushSendSchedule>() {

			@Override
			public DirectPushSendSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
				DirectPushSendSchedule schedule = new DirectPushSendSchedule();
				schedule.setAppGrpId(rs.getInt(ApnsFeedbackSchedule.APP_GRP_ID));
				schedule.setAppGrpKey(rs.getString(ApnsFeedbackSchedule.APP_GRP_KEY));
				return schedule;
			}
		});
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		return 0;
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}
}
