package com.humuson.tms.batch.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.humuson.tms.batch.domain.DirectQueue;
import com.humuson.tms.batch.domain.DirectQueueResult;
import com.humuson.tms.batch.service.DirectPushResultService;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class DirectPushResultServiceImpl implements DirectPushResultService {
	
	@Autowired protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	@Autowired protected JdbcTemplate jdbcTemplate;
	
	@Setter private String updateDirectQueue;
	@Setter private String insertDirectQueueResult;
	
	/*
	 * 
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int updateDirectQueue(DirectQueue pushQueue) {
		int result = namedParameterJdbcTemplate.update(updateDirectQueue, pushQueue.toMap());
		return result;
	}
	
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] batchUpdateDirectQueue(List<DirectQueue> list) {
		
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(list.toArray());
		int[] result = null;
		try {
			result = namedParameterJdbcTemplate.batchUpdate(updateDirectQueue, params);
		} catch (Exception e) {
			log.error("batch update failed", e);
			result = null;
		}
		return result;
	}

	@Override
	public int insertDirectQueueResult(DirectQueueResult directQueueResult) {
		int result = namedParameterJdbcTemplate.update(insertDirectQueueResult, directQueueResult.toMap());
		return result;
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] batchInsertDirectQueueResult(List<DirectQueueResult> list) {
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(list.toArray());
		int[] result = null;
		try {
			result = namedParameterJdbcTemplate.batchUpdate(insertDirectQueueResult, params);
		} catch (Exception e) {
			log.error("batch update failed", e);
			result = null;
		}
		return result;
	}
}
