package com.humuson.tms.batch.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import com.humuson.tms.batch.job.constrants.CondTargetOracleHintConstrants;
import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;
import com.humuson.tms.batch.service.ComposeTargetSqlService;
import com.humuson.tms.common.model.target.TargetInfo;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.TargetType;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class ComposeTargetSqlServiceImpl implements ComposeTargetSqlService {
	
	protected static final int NOT_EXIST = 0;
	protected static final int EXIST = 1;
	protected static final String VALUE = "VALUE";
	protected static final String CLASS = "TARGET_CLASS";
	protected static final String USER = "USER";
	protected static final String OPERATOR = "OPERATOR";
	protected static final String COLUMN_NAME = "TARGET_COLUMN";

	protected static final String DEVICE = "DEVICE";
	protected static final String APP_VER = "APP_VER";
	protected static final String OS_VER = "OS_VER";
	
	protected static final String DEVICE_ANALY_ID = "DEVICE_ANALY_ID";
	protected static final String APP_VER_ANALY_ID = "APP_VER_ANALY_ID";
	protected static final String OS_VER_ANALY_ID = "OS_VER_ANALY_ID";
	
	protected static final String ALL_DEVICE = "A";
	protected static final String LOGOUT_DEVICE = "U";
	protected static final String LOGIN_DEVICE = "L";
	
	protected static final String ANDROID = "A";
	protected static final String IOS = "I";
	protected static final String EQUAL = "=";
	protected static final String IN = "IN";
	protected static final String USE = "Y";
	
	protected static final String IS_EMPTY = " = ''";
	protected static final String IS_NOT_EMPTY = " != ''";
	
	protected static final String IS_NULL = " IS NULL";
	protected static final String IS_NOT_NULL = " IS NOT NULL";
	
	
	@Setter private String selectTargetCondition;
//	@Setter private String noLoginSelectClause;
//	@Setter private String siteSelectClause;
//	@Setter private String appBaseFromClause;
//	@Setter private String siteBaseFromClause;
//	@Setter private String joinAppUserDeviceTable;
//	@Setter private String joinSiteUserTable;
//	
//	@Setter private String appBaseWhereClause;
//	@Setter private String baseWhereClause ;
//	@Setter private String siteCustIdClause;
//	@Setter private String appCustIdClause;
	@Setter private String androidAppIdClause;
	@Setter private String iOSAppIdClause;
	@Setter private String userSessRawCond;
	
	@Setter private String siteUserMktEmailYn;
	@Setter private String siteUserMktPushYn;
	@Setter private String siteUserMktSmsYn;
	
	@Setter private String logoutSelectClause;
	@Setter private String logoutFromClause;
	@Setter private String logoutWhereClause;
	
	@Setter private String loginSelectClause;
	@Setter private String loginFromClause;
	@Setter private String loginWhereClause;
	
	@Setter private String loginSelectClauseForAmcTargeting;
	@Setter private String loginFromClauseForAmcTargeting;
	@Setter private String loginWhereClauseAppendForAmcTargeting;
	
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	@Autowired 
	NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	
	@Value("#{dbConfig['tms.jdbc.type']}")
	protected String dbType;

	@Override
	public int getCondTargetCount(String msgId, String channelType, TargetInfo targetInfo, ExecutionContext executionContext) {
		
		String sessionStartDate = "";
		String sessionEndDate = "";
		if (targetInfo.getTargetCondInfo() != null) {
			sessionStartDate = targetInfo.getTargetCondInfo().getSessionStartDate();
			sessionEndDate = targetInfo.getTargetCondInfo().getSessionEndDate();
		}
		final String targetUserType = targetInfo.getUseLogin();
		final String useCondition = targetInfo.getUseCondition();
		final String platformType = targetInfo.getUsePlatform();
		
		StringBuilder whereClauseBuilder = new StringBuilder();
		StringBuilder fromClauseBuilder = new StringBuilder();
		StringBuilder selectClauseBuilder = new StringBuilder();
		StringBuilder userSessionCondBuf = new StringBuilder();
		
		boolean isLoginTargeting = false;

		//MKT_FLAG Check
		boolean isMkt = "Y".equalsIgnoreCase(targetInfo.getMktYn()) ? true : false;
		
		if (log.isDebugEnabled()) {
			log.debug("useCondition:{}, sessionStartDate:{}, sessionEndDate:{}", 
					useCondition, sessionStartDate, sessionEndDate);
		}
		MapSqlParameterSource parameterSource = new MapSqlParameterSource();
		if(TargetType.AMC.getCode().equals(targetInfo.getTargetType())){
			selectClauseBuilder.append(loginSelectClauseForAmcTargeting);
			fromClauseBuilder.append(loginFromClauseForAmcTargeting);
			whereClauseBuilder.append(loginWhereClauseAppendForAmcTargeting);
		}else if (ChannelType.PUSH.getCode().equals(channelType)
				|| ChannelType.PUSH.getCode().equals(targetInfo.getFirstChannelType())) { 	// push channel
//			whereClauseBuilder.append(appBaseWhereClause);
			String step1 = null;
			String step2 = null;
			int androidAppId = executionContext.getInt(JobExecutionContextConstrants.KEY_ANDROID_ID,-1);
			int iosAppId = executionContext.getInt(JobExecutionContextConstrants.KEY_IOS_ID,-1);
			if (targetUserType.equals(ALL_DEVICE)) {
//				selectClauseBuilder.append(siteSelectClause);
//				selectClauseBuilder.append(siteUserMktPushYn);
//				fromClauseBuilder.append(appBaseFromClause);
				step1 = executionContext.getString(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP1,"unpass");
				step2 = executionContext.getString(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP2,"unpass");
				executionContext.put(JobExecutionContextConstrants.TAGET_USER_TYPE, ALL_DEVICE);
			} 
			
			 if (targetUserType.equals(LOGOUT_DEVICE) || (targetUserType.equals(ALL_DEVICE) && "unpass".equals(step1))) {
				selectClauseBuilder.append(logoutSelectClause);
				fromClauseBuilder.append(logoutFromClause);
				whereClauseBuilder.append(logoutWhereClause);
			} else {		// 회원 조건 추가
				selectClauseBuilder.append(loginSelectClause);
				fromClauseBuilder.append(loginFromClause);
				whereClauseBuilder.append(loginWhereClause);
				isLoginTargeting = true;
			}
			
			// OS (ANDROID OR IOS) 조건 추가
			if (ANDROID.equals(platformType)) {
				whereClauseBuilder.append(androidAppIdClause);
			} else if (IOS.equals(platformType)) {
				whereClauseBuilder.append(iOSAppIdClause);
			}
			
			if ("Y".equals(useCondition)) {
				if (!"".equals(sessionStartDate)
						&& !"".equals(sessionEndDate)) {	//조건 설정 타겟팅
					userSessionCondBuf.append(userSessRawCond);
				}
				
				List<Map<String, Object>> targetConditionList = 
						jdbcTemplate.queryForList(selectTargetCondition,androidAppId,iosAppId,msgId);
				
				String condClass = null;
				String userCondKey = null;
				String userCondValue = null;
				String appendix = null;
			
				List<String> deviceCond = new ArrayList<String>();
				List<String> osVerCond = new ArrayList<String>();
				List<String> appVerCond = new ArrayList<String>();
				
				Map<String,List<String>> condListMap = new HashMap<String,List<String>>(); 
				
				condListMap.put(DEVICE, deviceCond);
				condListMap.put(APP_VER, appVerCond);
				condListMap.put(OS_VER, osVerCond);
				
				for(Map<String, Object> targetConditionMap : targetConditionList) {
					if (log.isDebugEnabled()) {
						log.debug("targetConditionMap :[{}]", targetConditionMap.toString());
					}
					
					condClass = targetConditionMap.get(CLASS).toString();
					userCondKey = targetConditionMap.get(COLUMN_NAME).toString().toLowerCase();
					userCondValue = targetConditionMap.get(VALUE).toString();
					if(!USER.equals(condClass) ){
						List<String> cond = condListMap.get(condClass);
						cond.add(userCondValue);
					}else{
						userSessionCondBuf.append("AND ");
						userSessionCondBuf.append(userCondKey.toLowerCase());
						userSessionCondBuf.append(" ").append(targetConditionMap.get(OPERATOR)).append(" ");
						
						userSessionCondBuf.append(":"+userCondKey);
						executionContext.put(userCondKey, targetConditionMap.get(VALUE).toString());
						parameterSource.addValue(userCondKey, targetConditionMap.get(VALUE));
					}
					
				}
				
				for(String s : condListMap.keySet()){
					
					if(DEVICE.equals(s)){
						List<String> condDetailList = condListMap.get(s);
						if(condDetailList.size() <= 0)
							continue;
						userSessionCondBuf.append(" AND ");
						userSessionCondBuf.append(" ( ");
						for(int i=0; i < condDetailList.size(); i++){
							userSessionCondBuf.append(DEVICE_ANALY_ID).append("=").append(condDetailList.get(i));
							
							if(i != condDetailList.size()-1){
								userSessionCondBuf.append(" OR ");
							}
						}
						userSessionCondBuf.append(" ) ");
					}else if(APP_VER.equals(s)){
						List<String> condDetailList = condListMap.get(s);
						if(condDetailList.size() <= 0)
							continue;
						userSessionCondBuf.append(" AND ");
						userSessionCondBuf.append(" ( ");
						for(int i=0; i < condDetailList.size(); i++){
							userSessionCondBuf.append(APP_VER_ANALY_ID).append("=").append(condDetailList.get(i));
							
							if(i != condDetailList.size()-1){
								userSessionCondBuf.append(" OR ");
							}
						}
						userSessionCondBuf.append(" ) ");
					}else if(OS_VER.equals(s)){
						List<String> condDetailList = condListMap.get(s);
						if(condDetailList.size() <= 0)
							continue;
						userSessionCondBuf.append(" AND ");
						userSessionCondBuf.append(" ( ");
						for(int i=0; i < condDetailList.size(); i++){
							userSessionCondBuf.append(OS_VER_ANALY_ID).append("=").append(condDetailList.get(i));
							
							if(i != condDetailList.size()-1){
								userSessionCondBuf.append(" OR ");
							}
						}
						userSessionCondBuf.append(" ) ");
					}
				}
				
			} // END FOR LOOP
				
			// TMS_APP_SESS_RAW 조건 존재시 SUB QUERY를 WHERE절에 추가
			if (userSessionCondBuf.length() > 0) {
				if ("mysql".equalsIgnoreCase(dbType)
						|| "mariadb".equalsIgnoreCase(dbType)) {
					userSessionCondBuf.append(" LIMIT 1 ");
				}
				userSessionCondBuf.append(")");
				
				whereClauseBuilder.append(userSessionCondBuf.toString());
			}
		}
		String select = selectClauseBuilder.toString();
		String where = whereClauseBuilder.toString();
		
		executionContext.put(JobExecutionContextConstrants.KEY_SORT_KEY, "DEVICE_ID");
		
		//오라클 일떄 - 페이징
		if("ORACLE".equalsIgnoreCase(dbType)){
			// 추가 조건을 사용하고 로그인일때
			if ("Y".equals(useCondition) && isLoginTargeting) {
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGIN_CONDITION_USE_PAGING_QUERY_HINT);
				where = where.replace(CondTargetOracleHintConstrants.REPLACE_SESS_RAW_HINT, CondTargetOracleHintConstrants.ORACLE_LOGIN_SESS_RAW_PAGING_QUERY_HINT);
			}else if ("Y".equals(useCondition)){
				//추가 조건을 사용하고 로그아웃일떄
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGOUT_CONDITION_USE_PAGING_QUERY_HINT);
				where = where.replace(CondTargetOracleHintConstrants.REPLACE_SESS_RAW_HINT, CondTargetOracleHintConstrants.ORACLE_LOGOUT_SESS_RAW_PAGING_QUERY_HINT);
			}else if(isLoginTargeting){
				// 추가 조건이 없고 로그인일때
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGIN_PAGING_QUERY_HINT);
			}else{
				// 추가조건이 없고 로그아웃일때
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGOUT_PAGING_QUERY_HINT);
			}
		}
		
		executionContext.put(JobExecutionContextConstrants.KEY_SELECT_CLAUSE, select);
		executionContext.put(JobExecutionContextConstrants.KEY_FROM_CLAUSE, fromClauseBuilder.toString());
		executionContext.put(JobExecutionContextConstrants.KEY_WHERE_CLAUSE, where);
		
		parameterSource.addValue("siteId", targetInfo.getSiteId());
		parameterSource.addValue("appGrpId", targetInfo.getTargetCondInfo().getAppGrpId());
		parameterSource.addValue("androidAppId", targetInfo.getTargetCondInfo().getAndroidAppId());
		parameterSource.addValue("iosAppId", targetInfo.getTargetCondInfo().getIOsAppId());
		parameterSource.addValue("startDate", targetInfo.getTargetCondInfo().getSessionStartDate());
		parameterSource.addValue("endDate", targetInfo.getTargetCondInfo().getSessionEndDate());
		
		
		// 카운트용 쿼리 만들기 시작.
		select = "1 AS cnt";
		where = whereClauseBuilder.toString();
		
		//오라클 일떄 - 카운트
		if("ORACLE".equalsIgnoreCase(dbType)){
			select = CondTargetOracleHintConstrants.REPLACE_HINT + " 1 ";
			// 추가 조건을 사용하고 로그인일때
			if ("Y".equals(useCondition) && isLoginTargeting) {
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGIN_CONDITION_USE_COUNT_QUREY_HINT);
				where = where.replace(CondTargetOracleHintConstrants.REPLACE_SESS_RAW_HINT, CondTargetOracleHintConstrants.ORACLE_LOGIN_SESS_RAW_COUNT_QUREY_HINT);
			}else if ("Y".equals(useCondition)){
				//추가 조건을 사용하고 로그아웃일떄
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGOUT_CONDITION_USE_COUNT_QUREY_HINT);
				where = where.replace(CondTargetOracleHintConstrants.REPLACE_SESS_RAW_HINT, CondTargetOracleHintConstrants.ORACLE_LOGOUT_SESS_RAW_COUNT_QUREY_HINT);
			}else if(isLoginTargeting){
				// 추가 조건이 없고 로그인일때
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGIN_COUNT_QUERY_HINT);
			}else{
				// 추가조건이 없고 로그아웃일때
				select = select.replace(CondTargetOracleHintConstrants.REPLACE_HINT, CondTargetOracleHintConstrants.ORACLE_LOGOUT_COUNT_QUERY_HINT);
			}
		}
		
		// 타겟 카운트 정보는 ALL DEVICE 일때 1단계에서 Total Count 모두 계산하여 업데이트 처리함.
		// 불필요한 Count 쿼리 실행방지용.
		if("pass".equals(executionContext.getString(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP1,"unpass"))){
			return 0;
		}
		
		log.info("------{}-------" , "select count(*) from ( SELECT "+
					select 
					+" FROM "+ fromClauseBuilder.toString() 
					+" WHERE "+ where
					+ ") tmp");
		
		int targetCnt = namedParameterJdbcTemplate.queryForObject("select count(*) from ( SELECT "+
				select 
				+" FROM "+ fromClauseBuilder.toString() 
				+" WHERE "+ where
				+ ") tmp", parameterSource,
				Integer.class);
		
		if (log.isDebugEnabled()) {
			log.info("COND Target SQL:{}, count :{}", "select count(*) from ( SELECT "+
					select 
					+" FROM "+ fromClauseBuilder.toString() 
					+" WHERE "+ where
					+ ") tmp", targetCnt);
		}
		
		return targetCnt;
	}
}
