package com.humuson.tms.batch.service.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.humuson.tms.batch.domain.ApnsFeedback;
import com.humuson.tms.batch.service.AppUserRemover;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class AppUserRemoverImpl implements AppUserRemover {
	
	@Autowired protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	
	@Setter private String updateIosUnAcitveToken;
	@Setter private String updateAndroidNotRegisteredToken;
	@Setter private String insertDeleteDeviceList;
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.AppUserRemover#updateIosUnActiveToken(java.util.List)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] updateIosUnActiveToken(List<ApnsFeedback> list) {
		log.info("iOS Expired Tokens [size:{}]", list.size());
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(list.toArray());
		return namedParameterJdbcTemplate.batchUpdate(updateIosUnAcitveToken, params);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.AppUserRemover#updateIosUnActiveToken(com.humuson.tms.batch.domain.ApnsFeedback)
	 */
	@Override
	public int updateIosUnActiveToken(ApnsFeedback apnsFeedback) {
		return namedParameterJdbcTemplate.update(updateIosUnAcitveToken, apnsFeedback.toMap());
	}

	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.AppUserRemover#updateAndroidNotRegisterToken(java.lang.Integer)
	 */
	@Override
	public int updateAndroidNotRegisterToken(Integer deviceId) {
		return namedParameterJdbcTemplate.getJdbcOperations().update(updateAndroidNotRegisteredToken, deviceId);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.AppUserRemover#updateAndroidNotRegisterToken(java.util.List)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] updateAndroidNotRegisterToken(List<Integer> list) {
		log.info("update Android NotRegistered Tokens [size:{}]", list.size());
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(list.toArray());
		return namedParameterJdbcTemplate.batchUpdate(updateAndroidNotRegisteredToken, params);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.AppUserRemover#insertAppRemoveDeviceList(java.lang.Integer)
	 */
	@Override
	public int insertAppRemoveDeviceList(Integer deviceId) {
		return namedParameterJdbcTemplate.getJdbcOperations().update(insertDeleteDeviceList, deviceId);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.humuson.tms.batch.service.AppUserRemover#insertAppRemoveDeviceList(java.util.List)
	 */
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] insertAppRemoveDeviceList(final List<Integer> list) {
		log.info("insert Android NotRegistered Tokens [size:{}]", list.size());
		return namedParameterJdbcTemplate.getJdbcOperations().batchUpdate(insertDeleteDeviceList,
				new BatchPreparedStatementSetter() {
					
					@Override
					public void setValues(PreparedStatement ps, int i) throws SQLException {
						ps.setInt(1, list.get(i));
					}
					
					@Override
					public int getBatchSize() {
						return list.size();
					}
				});
	}

}
