package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.AndroidDelDeviceCleanzingSchedule;
import com.humuson.tms.batch.service.ScheduleService;

import lombok.Setter;
/**
 * APNS의 Feedback 결과를 수신하여 iOS 앱 삭제자를 처리 프로세스
 *
 * @author hyogun
 *
 */
public class AndroidDelDeviceCleanzingScheduleService implements ScheduleService<AndroidDelDeviceCleanzingSchedule> {
	/**
	 * 
	 */
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	
	@Setter private String selectSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public List<AndroidDelDeviceCleanzingSchedule> getScheduleList() {
		return getScheduleList(new Object[]{});
	}
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String key, boolean isRun) {
		runningScheduleMap.put(key, isRun);
	}
	
	@Override
	public List<AndroidDelDeviceCleanzingSchedule> getScheduleList(Object[] params) {
		return this.jdbcTemplate.query(this.selectSchedule, params,
				new RowMapper<AndroidDelDeviceCleanzingSchedule>() {

			@Override
			public AndroidDelDeviceCleanzingSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
				AndroidDelDeviceCleanzingSchedule schedule = new AndroidDelDeviceCleanzingSchedule();
				schedule.setCount(rs.getInt(AndroidDelDeviceCleanzingSchedule.COUNT));
				return schedule;
			}
		});
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		return 0;
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}
}
