package com.humuson.tms.batch.service;

import java.util.Map;

import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import com.humuson.tms.batch.domain.BaseResult;
import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.constrants.ChannelType;

/**
 * 
 * @author hyogun
 *
 */
public interface UpdateResultService {
	
	/**
	 * 
	 * @param chnType
	 * @param chnSendType
	 * @param rtnType
	 * @param sql
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public int[] updateList(ChannelType chnType, 
			ChannelSendType chnSendType, 
			String rtnType, String sql,
			SqlParameterSource[] param) throws Exception;
	
	/**
	 * 
	 * @param sql
	 * @param results
	 * @return
	 * @throws Exception
	 */
	public int[] updateCheckFlag(String sql, BaseResult[] results) throws Exception;
	
	/**
	 * 
	 * @param updateSql
	 * @param result
	 * @return
	 */
	public int updateCheckFlag(String updateSql, BaseResult result);
	
	/**
	 * 
	 * @param selectExistClickInfo
	 * @param param
	 * @return
	 */
	public int alreadExistClickInfo(String selectExistClickInfo, BeanPropertySqlParameterSource param);
	
	/**
	 * 
	 * @param sql
	 * @param statMap
	 * @return
	 * @throws Exception
	 */
	public int updateStat(String sql,Map<String,Object> statMap) throws Exception;
	
	/**
	 * 
	 * @param updateSql
	 * @param params
	 * @return
	 * @throws Exception
	 */
	public int[] updateResponseStat(String updateSql, SqlParameterSource[] params ) throws Exception;
}
