package com.humuson.tms.batch.service;

import java.util.List;

import com.google.android.gcm.server.Message;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;

/**
 * PMS에서 Push 발송을 위한 인터페이스
 * @author hyogun
 *
 */
public interface PushSendService<T,C> {
	
	/**
	 * TMS_APP_INFO의 정보로 APNS 접속 및 GCM Sender 접속 설정
	 * @param appInfo
	 */
	void init(App appInfo);
	
	/**
	 * APNS 접속 해제 및 Private Connection 정리 메소드
	 */
	void close();

	/**
	 * 
	 * @param list
	 * @param isGcmReSend
	 * @param unActivePublish
	 * @return
	 * @throws Exception
	 */
	C request(T list,
			boolean isGcmReSend, boolean unActivePublish) throws Exception;

	/**
	 * 푸시 발송 요청 메소드 (개인화 메시지 전송)
	 * Android : Private => 실패 => GCM
	 * iOS : APNS 전송
	 * @param list
	 * @param isGcmReSend
	 * @param unActivePublish
	 * @param useWakeupGcm
	 * @return
	 */
	C request(T list,
			boolean isGcmReSend, boolean unActivePublish, boolean useWakeupGcm);

	/**
	 * 푸시 발송 요청 메소드 (동보 형태 메시지 전송)
	 * Android : Private => 실패 => GCM
	 * iOS : APNS 전송
	 * @param list
	 * @param pushMessage
	 * @param isGcmReSend
	 * @return
	 */
	C request(T list,
			PushMessage pushMessage, boolean isGcmReSend);

	/**
	 * 푸시 발송 요청 메소드 
	 * Android : Private => 실패 => GCM
	 * iOS : APNS 전송
	 * @param list
	 * @param pushMessage
	 * @param isGcmReSend
	 * @param unActivePublish
	 * @return
	 * @throws Exception
	 */
	C request(T list,
			PushMessage pushMessage, boolean isGcmReSend,
			boolean unActivePublish) throws Exception;

	/**
	 * 푸시 발송 요청 메소드 
	 * Android : Private => 실패 => GCM
	 * iOS : APNS 전송
	 * @param list
	 * @param pushMessage
	 * @param isGcmReSend
	 * @param unActivePublish
	 * @param useWakeupGcm
	 * @return
	 */
	C request(T list,
			PushMessage pushMessage, boolean isGcmReSend,
			boolean unActivePublish, boolean useWakeupGcm);
}
