package com.humuson.tms.batch.service;

import java.util.List;

import org.springframework.stereotype.Service;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.common.model.CcsMessageId;
import com.humuson.tms.mq.model.MgsPush.PushPayload;

/**
 * 푸시 전송 결과 반영 프로세스 담당 클래스
 * @author hyogun
 *
 */
@Service
public interface PushResultService {
	
	/**
	 * 
	 * @param pushQueue
	 * @return
	 */
	int updateSendingStatus(PushQueue pushQueue);
	
	/**
	 * 
	 * @param list
	 * @return
	 */
	int[] batchUpdateSendingStatus(List<PushQueue> list);

	/**
	 * 
	 * @param pushQueue
	 * @return
	 */
	int updatePushQueue(PushQueue pushQueue);
	
	/**
	 * 
	 * @param list : List<PushQueue>
	 * @return
	 */
	int[] batchUpdatePushQueue(List<PushQueue> list);
	
	/**
	 * 
	 * @param result
	 * @return
	 */
	int updatePushResult(PushResult result);

	/**
	 * 
	 * @param resList
	 * @return
	 */
	void batchUpdatePushResult(List<PushResult> resList);
	
	
	int deleteInsertPushResult(CcsMessageId msg, String errorCode);
	
	int batchInsertSendingStatus(List<PushPayload> privateSendList, App appInfo, String serverId);
	
	int[] updateMqResendList(List<Object[]> prvPushMqUpdateList);
	
	int[] deleteMqResendList(List<Object[]> prvPushMqDeleteList);
	
	int deleteMqResend(String prvPushMqDeleteTargetReqUid);
	
	/*
	 * XMPP deliver process
	 * */
	int insertPushDeliver(CcsMessageId msg, String errorCode, String resDate);

	
}
