package com.humuson.tms.batch.service;

/**
 * rainboots server 에세 push request 또는 push feedback 정보를 가져오기 위한 인터페이스
 * 
 * @author hyogun
 *
 * @param <T> 반환 클래스 PushResponse or FeedbackResponse
 * @param <C> 요청 클래스 PushRequest or FeedbackRequest
 */
public interface PrivatePushService<T,C> {
	
	public static final String DELIM = "[,]";
	
	public void init();
	
	public void connect();
	
	public void disconnect();
	
	public T request(C requestProtoBuf);
	
	public boolean useRainboots();
	
	public void setRunning(boolean isRunning);
	
	public boolean isRunning();
	
	public boolean isActive();
}

