package com.humuson.tms.batch.service;

import org.springframework.jms.core.JmsTemplate;

import com.humuson.tms.mq.model.MgsPush;;

/**
 * 
 * @author hyogun
 *
 */
public interface MqProducer {
	
	/**
	 * 
	 * @param request 	  : MgsPush 전송 메시지
	 */
	void send(final MgsPush.Response response);
	
	/**
	 * 
	 * @param request 	  : MgsPush 전송 메시지
	 */
	void send(final MgsPush.Request request);
	
	/**
	 * @param destQueName : queueName
	 * @param request 	  : MgsPush 전송 메시지
	 */
	void send(String destQueName, final MgsPush.Request request);
	
	/**
	 * Spring jmsTemplate Setter 
	 * @param jmsTemplate
	 */
	void setJmsTemplate(JmsTemplate jmsTemplate);
	
	/**
	 * default producer queue name 
	 * @param destination
	 */
	void setDefaultDestination(String destination);
	
	/**
	 * return default producer queue name 
	 */
	String getDefaultDestination();
}
