package com.humuson.tms.batch.service;

import java.util.Collection;
import java.util.List;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.Result;
import com.humuson.tms.batch.domain.App;

/**
 * @author sgeom
 *
 * @param <T> Return Type - Send Result
 * @param <C> Parameter Type - Push Send Info ( deviceId, token, msg )
 * 
 * GCM 발송을 HTTP로 처리 하기 위한 인터페이스
 */
public interface GcmHttpService<T,C> {
		
		public void init(App appInfo);
		
		public void setServerId(String serverId);
	
		/**
		 * 
		 * @param pushSendInfo - 단건 발송대상
		 * @param gcmApiKey - 해당 키값으로 구현체에서 관리하는 Sender를 찾아 발송함 
		 * @return 발송결과 
		 * 
		 */
		public T sendGcmMessage(C pushSendInfo, String gcmApiKey);
		
		/**
		 * @param pushSendInfo - 발송대상 리스트(Collection)
		 * @param gcmApiKey - 해당 키값으로 구현체에서 관리하는 Sender를 찾아 발송함 
		 * @return 발송결과 리스트
		 * 
		 * 구현체에서 소유하고 있는 Sender를 반복적으로 특정 Pool 또는 Map 에서 Get 하는 최소화 하기위함 
		 * Get 할때 지연요소나 딜레이가 없다면 sendGcmMessage 을 반복호출하여도 무방함.
		 */
		public List<T> sendGcmOne2OneList(Collection<C> pushSendInfo, String gcmApiKey);
	
		/**
		 * @param pushSendInfo - 발송대상 배열
		 * @param msg - 모든 대상에 대한 공통 메시지
		 * @param gcmApiKey - 해당 키값으로 구현체에서 관리하는 Sender를 찾아 발송함
		 * @return
		 */
		public List<T> sendGcmMulticastMessage(C[] pushSendInfo, final Message msg, String gcmApiKey);
 
		/**
		 * @param result - GCM 결과 
		 * @param pushSendInfo - 발송대상 
		 * @return
		 */
		public T getGcmResult(Result result, C pushSendInfo);
		
		
		/**
		 * @param pushSendInfo - 발송대상
		 * @return GCM Message를 발송대상에 맞도록 만들어 반
		 */
		public Message makeGcmMessage(C pushSendInfo); 
		
}
