package com.humuson.tms.batch.scheduler;

import java.util.List;
import java.util.Map;

import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobParameters;

import com.humuson.tms.batch.domain.AndroidDelDeviceCleanzingSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;

/**
 * @author 
 * 
 */
public class AndroidDelDeviceCleanzingScheduler extends AbstractScheduler<AndroidDelDeviceCleanzingSchedule> {

	private static Logger logger = LoggerFactory.getLogger(AndroidDelDeviceCleanzingScheduler.class);

	@Override
	protected void scheduleExecute(JobExecutionContext context) {
		
		Map<String, Object> jobDataMap = context.getMergedJobDataMap();
		
		String jobName = (String) jobDataMap.get(JOB_NAME);
		
			
		List<AndroidDelDeviceCleanzingSchedule> androidDelUserScheduleList = scheduleService.getScheduleList();
		
		for (AndroidDelDeviceCleanzingSchedule androidDelUserSchedule : androidDelUserScheduleList) {
			if (androidDelUserSchedule.getCount() == 0
					|| scheduleService.isRunning(jobName)) {
				logger.debug("AndroidDelUserSchedule not match if(data cnt :{} OR job is running :{})skip schedule!",androidDelUserSchedule.getCount(), scheduleService.isRunning(jobName));
				continue;
			}
			
			long time = System.currentTimeMillis() / 300000;

			jobDataMap.put(JobParamConstrants.JOB_NAME, jobName);
			jobDataMap.put(JobParamConstrants.REQ_TIME, time);
			
			JobParameters jobParameters = getJobParametersFromJobMap(jobDataMap);
			if (logger.isDebugEnabled()) {
				logger.debug("============================");
				logger.debug(jobParameters.toString());
				logger.debug("============================");
			}
			boolean isExist = jobRepository.isJobInstanceExists(jobName, jobParameters);
			
			if (!isExist) {
				
				try {
					jobLauncher.run(jobLocator.getJob(jobName), jobParameters);
					scheduleService.setRunning(jobName, true);
					logger.info("AndroidDelUserSchedule job is launch!!!");
					
				} catch (JobExecutionException e) {
					logger.error("Could not execute job.", e);
				}
			}
		}
	}
}
