package com.humuson.tms.batch.mapper;


import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.common.model.target.TargetData;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class TargetDataRowMapper implements RowMapper<TargetData> {
	
	private ResultSetMetaData rsmd;
	private int columnCount = 0;
	private Set<String> columnNameSet = new HashSet<String>();
	
	@Override
	public TargetData mapRow(ResultSet rs, int rownum) throws SQLException {
		if (rownum <= 1 && rsmd == null) {
			rsmd = rs.getMetaData();
			columnCount = rsmd.getColumnCount();
			for (int i=1; i<=columnCount; i++) {
				if (log.isDebugEnabled()) {
					log.debug("rsmd column name set [i:{}, name:{}]", i, rsmd.getColumnLabel(i));
				}
				columnNameSet.add(rsmd.getColumnLabel(i));
			}
		}
		
		TargetData userDataBean = new TargetData();
		for (String key : columnNameSet) {
			try {
				userDataBean.put(key, rs.getString(key));
			} catch (Exception e) {
				log.error("Column Not Found Exception [keySet:{}], error:{}", key, e.getMessage());
				throw new SQLException(String.format("Column Not Found Exception [keySet:%s]", key));
			}
		}
		 
		return userDataBean;
		 
	}

}
