package com.humuson.tms.batch.mapper;


import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.SmsResultLog;
import com.humuson.tms.constrants.ChannelType;

/**
 * 
 * @author hyogun
 *
 */
public class SmsLogRowMapper implements RowMapper<SmsResultLog> {
	
	@Override
	public SmsResultLog mapRow(ResultSet rs, int rownum) throws SQLException {
		SmsResultLog smsResultLog = new SmsResultLog();
		smsResultLog.setChannelType(ChannelType.SMS);
		smsResultLog.setOrgTranId(rs.getString(SmsResultLog.ORG_TRAN_ID));
		smsResultLog.setErrorCode(rs.getString(SmsResultLog.ERROR_CODE));
		smsResultLog.setToPhone(rs.getString(SmsResultLog.TO_PHONE));
		smsResultLog.setResult(rs.getString(SmsResultLog.RESULT));
		smsResultLog.setPostId(rs.getString(SmsResultLog.POST_ID));
		smsResultLog.setListTable(rs.getString(SmsResultLog.LIST_TABLE));
		smsResultLog.setMemberId(rs.getString(SmsResultLog.MEMBER_ID));
		smsResultLog.setChannelSendType(ChannelSendType.valueOf(rs.getString(SmsResultLog.CHANNEL_SEND_TYPE)));
		smsResultLog.setTdate(rs.getString(SmsResultLog.T_DATE));
		smsResultLog.setDeliverTime(rs.getString(SmsResultLog.DELIVER_TIME));
		smsResultLog.setMonthDay(rs.getString(SmsResultLog.MMDD));
		smsResultLog.setHour(rs.getString(SmsResultLog.HH24));
		return smsResultLog;
	}
}
