package com.humuson.tms.batch.mapper;


import java.sql.ResultSet;
import java.sql.SQLException;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class PushQueueRowMapper implements RowMapper<PushQueue> {
	
	@Value("#{dbConfig['tms.jdbc.type']}")
	protected String dbType;
	
	/*
	 * (non-Javadoc)
	 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
	 */
	@Override
	public PushQueue mapRow(ResultSet rs, int rownum) throws SQLException {
		PushQueue pushQueue = new PushQueue();
		pushQueue.setPushId(rs.getLong(PushQueue.PUSH_ID))
		.setAppGrpId(rs.getInt("APP_GRP_ID"))
		.setAppId(rs.getInt("APP_ID"))
		.setNotiFlag(rs.getString(PushQueue.NOTI_FLAG))
		.setAppGrpKey(rs.getString(PushQueue.APP_GRP_KEY))
		.setReqUid(rs.getString(PushQueue.REQ_UID))
		.setCustId(rs.getString(PushQueue.CUST_ID))
		.setDeviceId(rs.getInt(PushQueue.DEVICE_ID))
		.setPushToken(rs.getString(PushQueue.PUSH_TOKEN))
		.setPushType(rs.getString(PushQueue.PUSH_TYPE))
		.setRcvName(rs.getString(PushQueue.RCV_NAME))
		.setRcvPhone(rs.getString(PushQueue.RCV_PHONE))
		.setSendStatus(rs.getString(PushQueue.SEND_STATUS))
		.setErrorCode(rs.getString(PushQueue.ERROR_CODE));
		
		PushMessage pushMessage = new PushMessage();
		pushMessage.setPushTitle(rs.getString(PushMessage.PUSH_TITLE))
		.setExpireDate(rs.getString(PushMessage.EXPIRE_DATE))
		.setPushMsg(rs.getString(PushMessage.PUSH_MSG))
		.setMsgType(rs.getString(PushMessage.MSG_TYPE))
		.setMsgUid(rs.getString(PushMessage.MSG_UID))
		.setInAppContent(rs.getString(PushMessage.INAPP_CONTENT))
		.setPopupContent(rs.getString(PushMessage.POPUP_CONTENT))
		.setPushImg(rs.getString(PushMessage.PUSH_IMG))
		.setPushKey(rs.getString(PushMessage.PUSH_KEY))
		.setPushValue(rs.getString(PushMessage.PUSH_VALUE))
		.setEtc1(rs.getString(PushMessage.ETC1))
		.setEtc2(rs.getString(PushMessage.ETC2))
		.setEtc3(rs.getString(PushMessage.ETC3))
		.setEtc4(rs.getString(PushMessage.ETC4))
		.setEtc5(rs.getString(PushMessage.ETC5))
		.setEtc6(rs.getString(PushMessage.ETC6));
		
		if("ORACLE".equalsIgnoreCase(dbType)){
			pushQueue.setRowId(rs.getString(PushQueue.SEND_LIST_ROW_ID));
		}
		
		pushQueue.setPushMessage(pushMessage);
		if (log.isDebugEnabled())
			log.debug("pushQueue {}", pushQueue.toString());
		return pushQueue;
	}
}
