package com.humuson.tms.batch.mapper;


import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;

/**
 * 
 * @author hyogun
 *
 */
public class PushQueueLogRowMapper implements RowMapper<PushResultLog> {
	
	@Value("#{dbConfig['tms.jdbc.type']}")
	protected String dbType;
	
	@Override
	public PushResultLog mapRow(ResultSet rs, int rownum) throws SQLException {
		PushResultLog pushResultLog = new PushResultLog();
		pushResultLog.setChannelType(ChannelType.PUSH);
		pushResultLog.setId(rs.getString(PushResultLog.ID));
		pushResultLog.setErrorCode(rs.getString(PushResultLog.ERROR_CODE));
		pushResultLog.setAppGrpId(rs.getInt(PushResultLog.APP_GRP_ID));
		pushResultLog.setRtnType(rs.getString(PushResultLog.RTN_TYPE));
		pushResultLog.setResultData(rs.getString(PushResultLog.DATA));
		pushResultLog.setReqUid(rs.getString(PushResultLog.REQ_UID));
		pushResultLog.setCustId(rs.getString(PushResultLog.CUST_ID));
		pushResultLog.setPostId(rs.getString(PushResultLog.POST_ID));
		pushResultLog.setListTable(rs.getString(PushResultLog.LIST_TABLE));
		pushResultLog.setMemberId(StringUtils.validString(rs.getString(PushResultLog.MEMBER_ID)));
		pushResultLog.setChannelSendType(ChannelSendType.valueOf(rs.getString(PushResultLog.CHANNEL_SEND_TYPE)));
		pushResultLog.setTdate(rs.getString(PushResultLog.T_DATE));
		pushResultLog.setDeliverTime(rs.getString(PushResultLog.DELIVER_TIME));
		pushResultLog.setAppOs(rs.getString(PushResultLog.OS));
		pushResultLog.setType(rs.getString(PushResultLog.TYPE));
		pushResultLog.setMonthDay(rs.getString(PushResultLog.MMDD));
		pushResultLog.setHour(rs.getString(PushResultLog.HH24));
		
		if("ORACLE".equalsIgnoreCase(dbType)){
			pushResultLog.setRowId(rs.getString(PushResultLog.ROW_ID));
		}
		
		if ("C".equals(pushResultLog.getRtnType())) {
			int idx = pushResultLog.getResultData().indexOf("^^");
			if (idx > 0) {
				pushResultLog.setClickId(pushResultLog.getResultData().substring(0, idx));
				pushResultLog.setClickUrl(pushResultLog.getResultData().substring(idx + 2));
			}
		}
		return pushResultLog;
	}
}
