package com.humuson.tms.batch.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import lombok.extern.slf4j.Slf4j;

import org.springframework.jdbc.core.RowMapper;

@Slf4j
public class LongIdRowMapper implements RowMapper<Long> {
	
	private static final String ID = "ID";
	
	public Long mapRow(ResultSet rs, int rownum) throws SQLException {
		// TODO Auto-generated method stub
		if (log.isDebugEnabled()) log.debug("id : {}", rs.getObject(ID));
		return Long.parseLong(rs.getString(ID));
	}

}

