package com.humuson.tms.batch.mapper;


import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.validation.BindException;

import com.humuson.tms.common.model.target.TargetData;

@Slf4j
public class FileTargetDataRowMapper implements FieldSetMapper<TargetData>{
	
	private int fieldSetCount = 0;
	private List<Integer> targetFileIdxList = new ArrayList<Integer>();
	
	public TargetData mapFieldSet(FieldSet fieldSet) throws BindException {
		
		if (fieldSetCount == 0) {
			fieldSetCount = fieldSet.getFieldCount();
		}
		
		if (log.isDebugEnabled())
			log.debug("fieldSet names:{}, values:{}", fieldSet.getNames().length, fieldSet.getValues().length);
		
		String[] names = fieldSet.getNames();
		String[] values = fieldSet.getValues();
		
		TargetData userDataBean = new TargetData();
		try {
			int size = targetFileIdxList.size();
			for (int i=0; i<size; i++) {
				if (targetFileIdxList.get(i) >= 0) {
					userDataBean.put(names[i], values[targetFileIdxList.get(i)]);
				}
			}
		} catch (Exception e) {
			log.error("target data bind error [{}]", fieldSet.getProperties().toString());
			throw new BindException(this, "fieldSetBind Error");
		}
		
		return userDataBean;
	}
	
	public void setTargetFileIdx(String targetFileIdx) {
		for (String idx : targetFileIdx.split("[|]")) {
			try {
				targetFileIdxList.add(Integer.parseInt(idx));
			} catch (Exception e) {
				log.error("idx parse error [targetFileIdx:{}, idx:{}]", targetFileIdx, idx);
				targetFileIdxList.add(-1);
			}
		}
	}
}
