package com.humuson.tms.batch.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.FatigueInfo;

public class FatigueInfoRowMapper implements RowMapper<FatigueInfo>{
	
	@Override
	public FatigueInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
		FatigueInfo fatigueInfo = new FatigueInfo();
		fatigueInfo.setMemberId(rs.getString(FatigueInfo.KEY_MEMBER_ID))
					.setDaySentCnt(rs.getInt(FatigueInfo.KEY_DAY_SENT_CNT))
					.setMonthSentCnt(rs.getInt(FatigueInfo.KEY_MONTH_SENT_CNT))
					.setChannelType(rs.getString(FatigueInfo.KEY_CHANNEL_TYPE));

		//  자동 캠페인을 처리하기 위한 부분
		if(rs.getMetaData().getColumnCount() > 4){
			fatigueInfo.setWorkday(rs.getString(FatigueInfo.KEY_WORKDAY) == null ? "" : rs.getString(FatigueInfo.KEY_WORKDAY));
			fatigueInfo.setSeqno(rs.getInt(FatigueInfo.KEY_SEQ_NO));
		}
		return fatigueInfo;
	}

}
