package com.humuson.tms.batch.mapper;


import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.DirectQueue;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class DirectQueueRowMapper implements RowMapper<DirectQueue> {
	
	@Value("#{dbConfig['tms.jdbc.type']}")
	protected String dbType;
	
	/*
	 * (non-Javadoc)
	 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
	 */
	@Override
	public DirectQueue mapRow(ResultSet rs, int rownum) throws SQLException {
		DirectQueue item = new DirectQueue();
		
		item.setSeq(rs.getLong(DirectQueue.SEQ));
		item.setAppGrpId(rs.getInt(DirectQueue.APP_GRP_ID));
		item.setAppGrpKey(rs.getString(DirectQueue.APP_GRP_KEY));
		item.setChGubun(rs.getString(DirectQueue.CH_GUBUN));
		item.setDeviceId(rs.getLong(DirectQueue.DEVICE_ID));
		item.setCustId(rs.getString(DirectQueue.TMS_M_ID));
		item.setCustName(rs.getString(DirectQueue.TMS_M_NAME));
		item.setPushToken(rs.getString(DirectQueue.TMS_M_TOKEN));
		item.setSubject(rs.getString(DirectQueue.SUBJECT));
		item.setContent(rs.getString(DirectQueue.CONTENT));
		item.setInappMsg(rs.getString(DirectQueue.PU_IN_APP));
		item.setPushValue(rs.getString(DirectQueue.PUSH_VALUE));
		item.setImgUrl(rs.getString(DirectQueue.IMG_URL));
		item.setRegDate(rs.getString(DirectQueue.REG_DATE));
		item.setMsgTpCd(rs.getString(DirectQueue.MSG_TP_CD));
		item.setReqUid(rs.getString(DirectQueue.REQ_UID));
		item.setPriority(rs.getInt(DirectQueue.PRIORITY));
		item.setToId(rs.getString(DirectQueue.TO_ID));
		item.setTtl(rs.getInt(DirectQueue.TTL));
		
		item.setNotiFlag(rs.getString(DirectQueue.NOTI_FLAG));
		item.setAppOs(rs.getString(DirectQueue.OS));
		return item;
	}
}
