package com.humuson.tms.batch.mapper;


import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.common.model.target.TargetData;

@Slf4j
public class DbTargetDataRowMapper implements RowMapper<TargetData> {
	
	private ResultSetMetaData rsmd;
	private int columnCount = 0;
	private Set<String> columnNameSet = new HashSet<String>();
	
	public TargetData mapRow(ResultSet rs, int rownum) throws SQLException {
		if (rownum == 0) {
			rsmd = rs.getMetaData();
			columnCount = rsmd.getColumnCount();
			for (int i=1; i<=columnCount; i++) {
				log.info("rsmd column name set [i:{}, name:{}]", i, rsmd.getColumnLabel(i));
				columnNameSet.add(rsmd.getColumnLabel(i));
			}
		}
		
		TargetData userDataBean = new TargetData();
		try {
			for (String key : columnNameSet) {
				userDataBean.put(key, rs.getString(key));
			}
		} catch (Exception e) {
			throw new SQLException("Column Not Found Exception");
		}
		 
		return userDataBean;
		 
	}

}
