package com.humuson.tms.batch.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import lombok.extern.slf4j.Slf4j;

import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.AppDeviceDeleteInfo;

@Slf4j
public class AppDeviceDeleteRowMapper implements RowMapper<AppDeviceDeleteInfo> {
	
	private static final String ID = "ID";
	private static final String REG_DATE = "REG_DATE";
	
	public AppDeviceDeleteInfo mapRow(ResultSet rs, int rownum) throws SQLException {
		// TODO Auto-generated method stub
		AppDeviceDeleteInfo delInfo = new AppDeviceDeleteInfo();
		delInfo.setDeviceId(rs.getLong(ID));
		delInfo.setRegDate(rs.getString(REG_DATE));
		return delInfo;
	}

}

