package com.humuson.tms.batch.job.tasklet;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.SiteInfo;

import lombok.Setter;

/**
 * 앱 사용자 수 갱신 프로세스
 * 
 * @author hyogun
 *
 */
public class SendTargetSummaryTasklet implements Tasklet {
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	@Setter private String selectPushUserCount;
	@Setter private String selectUserCount;
	@Setter private String updateUserCount;
	
	
	private final String PUSH="pushCount";
	private final String SMS="smsCount";
	private final String EMAIL="emailCount";
	
	Logger logger = LoggerFactory.getLogger(SendTargetSummaryTasklet.class);
		
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		List<SiteInfo> targetCountList = jdbcTemplate.query(selectUserCount, new RowMapper<SiteInfo>() {
			@Override
			public SiteInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
				// TODO Auto-generated method stub
				SiteInfo siteInfo = new SiteInfo();
				siteInfo.setSiteId(rs.getInt(SiteInfo.SITE_ID));
				siteInfo.setEmailUserCnt(rs.getLong(SiteInfo.EMAIL_USER_CNT));
				siteInfo.setSmsUserCnt(rs.getLong(SiteInfo.SMS_USER_CNT));
				return siteInfo;
			}
		});
		
		List<SiteInfo> pushCountList = jdbcTemplate.query(selectPushUserCount, new RowMapper<SiteInfo>() {
			@Override
			public SiteInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
				// TODO Auto-generated method stub
				SiteInfo siteInfo = new SiteInfo();
				siteInfo.setSiteId(rs.getInt(SiteInfo.SITE_ID));
				siteInfo.setPushUserCnt(rs.getLong(SiteInfo.PUSH_USER_CNT));
				return siteInfo;
			}
		});
		
		Map<Integer,SiteInfo> countMap = new HashMap<Integer,SiteInfo>(); 
		
		
		
		for (SiteInfo pushCount : pushCountList) {
					
				try {
					SiteInfo siteInfo = countMap.get(pushCount.getSiteId()); 
					if(siteInfo == null){
						siteInfo = new SiteInfo();
					}
					siteInfo.setPushUserCnt(pushCount.getPushUserCnt());
					countMap.put(pushCount.getSiteId(), siteInfo);
				} catch (Exception e) {
					logger.error("update user_count error", e);
				} finally {
//					logger.info("[appGrpId:{}] update user_count += {} elapseTime:{}", grpId, userCount, (System.currentTimeMillis() - startTime));
				}
		}
		
		for (SiteInfo targetCount : targetCountList) {
			
			try {
				SiteInfo siteInfo = countMap.get(targetCount.getSiteId()); 
				if(siteInfo == null){
					siteInfo = new SiteInfo();
				}
				siteInfo.setEmailUserCnt(targetCount.getEmailUserCnt());
				siteInfo.setSmsUserCnt(targetCount.getSmsUserCnt());
				countMap.put(targetCount.getSiteId(), siteInfo);
			} catch (Exception e) {
				logger.error("update user_count error", e);
			} finally {
//				logger.info("[appGrpId:{}] update user_count += {} elapseTime:{}", grpId, userCount, (System.currentTimeMillis() - startTime));
			}
	}
		
		for(int key : countMap.keySet()){
			long smsUserCnt = countMap.get(key).getSmsUserCnt();
			long emailUserCnt = countMap.get(key).getEmailUserCnt();
			long pushUserCnt = countMap.get(key).getPushUserCnt();
			long totalUserCnt  = smsUserCnt + emailUserCnt + pushUserCnt;
			jdbcTemplate.update(updateUserCount, smsUserCnt,emailUserCnt,pushUserCnt,totalUserCnt, key);
		}
		
		
		return RepeatStatus.FINISHED;
		
	}
}
