package com.humuson.tms.batch.job.tasklet;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.amc.client.AmcClient;
import com.humuson.amc.client.model.request.ContactRequest;
import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.ComposeTargetSqlService;
import com.humuson.tms.batch.service.PostIdDevideService;
import com.humuson.tms.batch.service.TargetServerService;
import com.humuson.tms.common.model.target.TargetCondInfo;
import com.humuson.tms.common.model.target.TargetDbInfo;
import com.humuson.tms.common.model.target.TargetFileInfo;
import com.humuson.tms.common.model.target.TargetInfo;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.TargetType;
import com.mchange.v2.c3p0.ComboPooledDataSource;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class InitTargetingTasklet implements Tasklet, StepExecutionListener {
	
	private StepExecution stepExecution;
	
	@Setter private String selectTargetInfo;
	@Setter private String updateTargetInfo;
	@Setter private String updateTargetTotalInfo;
	@Setter private String deleteSendList;
	@Setter private String deleteAmcTargetList;
	@Setter private String deleteTargetData;
	@Setter private String emailMappingHeader;
	@Setter private String smsMappingHeader;
	@Setter private String pushMappingHeader;
	@Setter private String totalMappingHeader;
	@Setter private String amcMappingHeader;
	
	@Setter private String selectAmcSiteKeyInfo;
	
	@Setter private String amcBaseUrl;
	
	@Value("#{config['target.file.upload.path']}")
	private String fileUploadPath;
	
	@Autowired TargetServerService targetServerService;
	@Autowired PostIdDevideService postIdDevideService;
	@Autowired ComposeTargetSqlService composeTargetSqlService;

	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	private AmcClient client;
	
	protected static final  String XLS = "xls";
	protected static final String XLSX = "xlsx";
	
	protected static final String ALL_DEVICE = "A";
	protected static final String LOGIN_DEVICE = "L";
	
	@Override
	public RepeatStatus execute(StepContribution contribution,
			ChunkContext chunkContext) throws Exception {
		final String postId = stepExecution.getJobParameters().getString(JobParamConstrants.POST_ID);
		final String msgId = stepExecution.getJobParameters().getString(JobParamConstrants.MSG_ID);
		final String targetType = stepExecution.getJobParameters().getString(JobParamConstrants.TARGET_TYPE);
		final String channelType = stepExecution.getJobParameters().getString(JobParamConstrants.CHN_TYPE);
		final String listTable = stepExecution.getJobParameters().getString(JobParamConstrants.SEND_LIST_TABLE);
		final String deduplicationYn = stepExecution.getJobParameters().getString(JobParamConstrants.DEDUPLICATION_YN);
		log.info("InitTargetingTasklet start [channel:{}, postId:{}, targetType:{}, deduplicationYn:{}]", channelType, postId, targetType, deduplicationYn);
		
		final TargetInfo targetInfo = this.getTargetInfo(targetType, channelType, msgId);
		targetInfo.setTargetType(targetType).setPostId(postId);
		
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_CHN_TYPE, channelType);
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_SEND_LIST_TABLE, listTable);
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_ADD_SITE_USER_YN, targetInfo.getAddSiteUserYn());
		
		int targetCnt = 0;
		
		stepExecution.getJobExecution().getExecutionContext()
		.put(JobExecutionContextConstrants.KEY_APP_GRP_ID, targetInfo.getAppGrpId());
		
		if (TargetType.FILE.getCode().equals(targetInfo.getTargetType())) {
			int lineToSkipCount = 0;

			String targetFileName = targetInfo.getTargetFileInfo().getFileName();
			String fileCharSet = targetInfo.getTargetFileInfo().getFileCharSet();
			String fileIdx = targetInfo.getTargetFileInfo().getFileIdx();
			
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_CHARSET, fileCharSet);
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_ID_TARGET_YN, targetInfo.getIdTargetYn());
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_FILE_NAME, targetFileName);
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_FILE_IDX, fileIdx);
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_CHARSET, targetInfo.getTargetFileInfo().getFileCharSet());
			
			if ("Y".equals(targetInfo.getTargetFileInfo().getTargetFileHeadFlag())) {
				lineToSkipCount = 1;
			}
			
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_DELIMITER, targetInfo.getTargetFileInfo().getFileDelim());
			
			if (ChannelType.EMAIL.getCode().equals(channelType)) {
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_HEADER, emailMappingHeader); 
			} else if (ChannelType.SMS.getCode().equals(channelType)) {
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_HEADER, smsMappingHeader); 
			} else if (ChannelType.PUSH.getCode().equals(channelType)) {
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_HEADER, pushMappingHeader);
			} else if (ChannelType.TOTAL.getCode().equals(channelType)) {
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_HEADER, totalMappingHeader);
			}
			
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_LINES_TO_SKIP, String.valueOf(lineToSkipCount));
			
			targetCnt = this.getTargetFileLineCount(targetInfo.getTargetFileInfo().getFileName(), 
					targetInfo.getTargetCnt(), lineToSkipCount);
			
		} else if (TargetType.DB.getCode().equals(targetInfo.getTargetType())) {
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_SQL, targetInfo.getTargetQuery());
			
			if (targetInfo.getTargetDbInfo() != null) {
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_JDBC_TYPE, targetInfo.getTargetDbInfo().getDbType());
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_JDBC_DRIVER, targetInfo.getTargetDbInfo().getDbDriver());
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_JDBC_URL, targetInfo.getTargetDbInfo().getDbUrl());
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_JDBC_USER, targetInfo.getTargetDbInfo().getDbUser());
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_JDBC_PASSWORD, targetInfo.getTargetDbInfo().getDbPassword());
			}
			
			targetCnt = getTargetDBTargetCnt(targetInfo);
			
		} else if (TargetType.COND.getCode().equals(targetInfo.getTargetType())) {
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_ANDROID_ID, targetInfo.getTargetCondInfo().getAndroidAppId());
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_IOS_ID, targetInfo.getTargetCondInfo().getIOsAppId());
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_SESSION_START_DATE, targetInfo.getTargetCondInfo().getSessionStartDate());
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_SESSION_END_DATE, targetInfo.getTargetCondInfo().getSessionEndDate());
			if (ALL_DEVICE.equals(targetInfo.getUseLogin()) &&
				"unpass".equalsIgnoreCase(stepExecution.getJobExecution().getExecutionContext().getString(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP1,"unpass")) ) {
				targetInfo.setUseLogin(LOGIN_DEVICE);
				targetCnt += composeTargetSqlService.getCondTargetCount(msgId, channelType, targetInfo, stepExecution.getJobExecution().getExecutionContext());
				targetInfo.setUseLogin(ALL_DEVICE);
			}
			targetCnt += composeTargetSqlService.getCondTargetCount(msgId, channelType, targetInfo, stepExecution.getJobExecution().getExecutionContext());
		} else if (TargetType.REL.getCode().equals(targetInfo.getTargetType())) {
			stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_SQL, targetInfo.getTargetQuery());
			
			targetCnt = jdbcTemplate.queryForObject("select count(*) from ("+ targetInfo.getTargetQuery() +") tmp",
					Integer.class);
		}else if(TargetType.AMC.getCode().equals(targetInfo.getTargetType())){
			Map<String,Object> keyInfo = jdbcTemplate.queryForMap(selectAmcSiteKeyInfo, targetInfo.getSiteId());
			if(ChannelType.PUSH.getCode().equals(channelType)
					|| ChannelType.PUSH.getCode().equals(targetInfo.getFirstChannelType())){
				stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_ANDROID_ID, targetInfo.getTargetCondInfo().getAndroidAppId());
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_IOS_ID, targetInfo.getTargetCondInfo().getIOsAppId());
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_SESSION_START_DATE, targetInfo.getTargetCondInfo().getSessionStartDate());
				stepExecution.getJobExecution().getExecutionContext()
					.put(JobExecutionContextConstrants.KEY_SESSION_END_DATE, targetInfo.getTargetCondInfo().getSessionEndDate());
				composeTargetSqlService.getCondTargetCount(msgId, channelType, targetInfo, stepExecution.getJobExecution().getExecutionContext());
				stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_CHN_TYPE, ChannelType.PUSH.getCode());
			}else{
				String sql = "select ATUL.CUST_ID TMS_M_ID, CUST_NAME TMS_M_NAME, CUST_EMAIL TMS_M_EMAIL, CUST_PHONE TMS_M_PHONE" 
						+ " FROM TMS_AMC_TARGETING_USER_LIST ATUL "  
						+ " LEFT JOIN  TMS_SITE_USER_LIST SUL ON ( ATUL.CUST_ID = SUL.CUST_ID AND SITE_ID = " + targetInfo.getSiteId() + ") "
						+ " WHERE MSG_ID = " + msgId;
				
				stepExecution.getJobExecution().getExecutionContext()
				.put(JobExecutionContextConstrants.KEY_SQL, sql);
			}
			
			stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_AMC_AUDIENCE_SEQ, targetInfo.getAudienceSeq());
			
			stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_AMC_SITE_KEY, keyInfo.get("AMC_SITE_KEY"));
			stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_AMC_WEB_KEY, keyInfo.get("AMC_WEB_KEY"));
			
			if (amcBaseUrl != null){
				client = new AmcClient.Builder().setBaseUri(amcBaseUrl).build();
			}else{
				client = new AmcClient.Builder().setBaseUri("http://119.207.76.91:7082/api").build();
			}
			
			ContactRequest req = new ContactRequest();
			req.setSize(1);
			req.setAudienceSeq(String.valueOf(targetInfo.getAudienceSeq()));
			req.setTimeout(20000);
			
			targetCnt = client.contact.get(req).get().getTotalCount(); 
		}
		
		if(!"pass".equalsIgnoreCase(stepExecution.getJobExecution().getExecutionContext().getString(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP1,"unpass"))){
			this.removePrevTargetData(msgId, targetInfo, channelType, targetCnt);
		}else{
			//조건검색타게팅-전체로 타게팅하고 비로그인 타게팅 후 로그인 대상 타겟팅시에만 수행되어야함.
//			jdbcTemplate.update(updateTargetTotalInfo,targetCnt,msgId);
		}
		
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_ENCRYPT_YN, targetInfo.getEncryptYn());
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_SITE_ID, targetInfo.getSiteId());
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_TOT_COUNT, targetCnt); 
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_FIRST_CHANNEL_TYPE, targetInfo.getFirstChannelType()); 
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_MKT_YN, targetInfo.getMktYn());
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_DEDUPLICATION_YN, targetInfo.getDeduplicationYn());
		stepExecution.getJobExecution().getExecutionContext()
			.put(JobExecutionContextConstrants.KEY_SEQNO, targetInfo.getSeqNo());
		
		log.info("jobExecutionContext [{}]", stepExecution.getJobExecution().getExecutionContext().toString());
		return RepeatStatus.FINISHED;
	}

	private int getTargetDBTargetCnt(final TargetInfo targetInfo)
			throws PropertyVetoException {
		int targetCnt;
		ComboPooledDataSource dataSource = new ComboPooledDataSource();
		dataSource.setDriverClass(targetInfo.getTargetDbInfo().getDbDriver());
		dataSource.setJdbcUrl(targetInfo.getTargetDbInfo().getDbUrl());
		dataSource.setUser(targetInfo.getTargetDbInfo().getDbUser());
		dataSource.setPassword(targetInfo.getTargetDbInfo().getDbPassword());
		
		JdbcTemplate targetJdbcTemplate = new JdbcTemplate(dataSource);
		targetCnt = targetJdbcTemplate.queryForObject("select count(*) from ("+ targetInfo.getTargetQuery() +") tmp",
				Integer.class);
		return targetCnt;
	}

	private int getTargetFileLineCount(String fileName, int prevTargetCount,
			int lineToSkipCount) throws IOException {
		int targetCnt;
		LineNumberReader  lnr = null;
		try {
			lnr = new LineNumberReader(
					new FileReader(
							new File(fileUploadPath.concat(File.separator).concat(fileName))
							));
			lnr.skip(Long.MAX_VALUE);
			log.info("lineNumber:{}, lineToSkipCount:{}", lnr.getLineNumber(), lineToSkipCount);
			targetCnt = prevTargetCount + lnr.getLineNumber() - lineToSkipCount + 1;
		} catch (Exception e) {
			log.error("file lineNumberReader error", e);
			targetCnt = 0;
		} finally {
			if (lnr != null) {
				lnr.close();
			}
		}
		return targetCnt;
	}
	
	private void removePrevTargetData(String msgId, TargetInfo targetInfo, String channelType, int targetCnt) {
		if ("N".equals(targetInfo.getNextTarget())) {
			
			List<String> postIdList = new ArrayList<String>();
			
			if ("Y".equals(targetInfo.getAbTestFileYn())) {
				List<Properties> list = postIdDevideService.getAbTestPostIds(msgId, targetInfo.getPostId());
				for (Properties prop : list) {
					postIdList.add(prop.getProperty("POST_ID"));
				}
			} else {
				postIdList.add(targetInfo.getPostId());
			}
			int count = 0;
			int totalDeleteCount = 0;
			for (String postId : postIdList) {
				targetServerService.initTargetServerInfo(postId);
				count = 0;
				totalDeleteCount = 0;
				do {
					count = jdbcTemplate.update(deleteSendList, postId);
					totalDeleteCount += count;
					log.info("prev target date remove...[postId:{}, count:{}]", postId, totalDeleteCount);
				} while (count > 0);
			}
			
			count = 0;
			totalDeleteCount = 0;
			
			if(TargetType.AMC.getCode().equals(targetInfo.getTargetType())){
				do {
					count = jdbcTemplate.update(deleteAmcTargetList, msgId);
					totalDeleteCount += count;
					log.info("prev amc target date remove...[msgId:{}, count:{}]", msgId, totalDeleteCount);
				} while (count > 0);
			}
			jdbcTemplate.update(updateTargetInfo, targetCnt, msgId);
		}
	}
	
	private TargetInfo getTargetInfo(final String targetType, final String channelType,  String msgId) {

		return jdbcTemplate.queryForObject(this.selectTargetInfo, new RowMapper<TargetInfo>(){
			
			@Override
			public TargetInfo mapRow(ResultSet rs, int rowNum)
					throws SQLException {
				TargetInfo targetInfo = new TargetInfo();
				targetInfo.setTargetType(targetType);
				
				if (TargetType.DB.getCode().equals(targetType)) {
					TargetDbInfo targetDbInfo = new TargetDbInfo();
					targetDbInfo.setDbDriver(rs.getString(TargetDbInfo.DB_DRV))
					.setDbType(rs.getString(TargetDbInfo.DB_TYPE))
					.setDbUrl(rs.getString(TargetDbInfo.DB_URL))
					.setDbUser(rs.getString(TargetDbInfo.DB_USR))
					.setDbPassword(rs.getString(TargetDbInfo.DB_PWD));
					
					targetInfo.setTargetDbInfo(targetDbInfo);
					targetInfo.setTargetQuery(rs.getString(TargetInfo.TARGET_DB_QUERY));
				} else if (TargetType.FILE.getCode().equals(targetType)) {
					TargetFileInfo targetFileInfo = new TargetFileInfo();
					targetFileInfo.setFileName(rs.getString(TargetFileInfo.TARGET_FILE_NAME))
					.setFileDelim(rs.getString(TargetFileInfo.TARGET_FILE_DELIM))
					.setFileIdx(rs.getString(TargetFileInfo.TARGET_FILE_IDX))
					.setTargetFileHeadFlag(rs.getString(TargetFileInfo.TARGET_FILE_HEAD_FLAG))
					.setFileCharSet(rs.getString(TargetFileInfo.TARGET_FILE_ENCODING));
					
					targetInfo.setTargetFileInfo(targetFileInfo)
						.setIdTargetYn(rs.getString(TargetInfo.ID_TARGET_YN));
					
				} else if (TargetType.COND.getCode().equals(targetType)) {
					TargetCondInfo targetCondInfo = new TargetCondInfo();
					targetCondInfo.setAndroidAppId(rs.getInt(TargetCondInfo.ANDROID_APP_ID));
					targetCondInfo.setIOsAppId(rs.getInt(TargetCondInfo.IOS_APP_ID));
					targetCondInfo.setAppGrpId(rs.getInt(TargetCondInfo.APP_GRP_ID));
					targetCondInfo.setSessionStartDate(rs.getString(TargetCondInfo.APP_SESS_START));
					targetCondInfo.setSessionEndDate(rs.getString(TargetCondInfo.APP_SESS_END));
					targetInfo.setUsePlatform(rs.getString(TargetInfo.USE_PLATFORM));
					targetInfo.setUseCondition(rs.getString(TargetInfo.USE_CONDITION));
					targetInfo.setTargetCondInfo(targetCondInfo);
				} else if (TargetType.REL.getCode().equals(targetType)) {
					targetInfo.setTargetQuery(rs.getString(TargetInfo.TARGET_DB_QUERY));
				}
				if(TargetType.AMC.getCode().equals(targetType)){
					
					if( ChannelType.PUSH.getCode().equals(channelType)){
						TargetCondInfo targetCondInfo = new TargetCondInfo();
						targetCondInfo.setAndroidAppId(rs.getInt(TargetCondInfo.ANDROID_APP_ID));
						targetCondInfo.setIOsAppId(rs.getInt(TargetCondInfo.IOS_APP_ID));
						targetCondInfo.setAppGrpId(rs.getInt(TargetCondInfo.APP_GRP_ID));
						targetCondInfo.setSessionStartDate(rs.getString(TargetCondInfo.APP_SESS_START));
						targetCondInfo.setSessionEndDate(rs.getString(TargetCondInfo.APP_SESS_END));
						targetInfo.setUsePlatform(rs.getString(TargetInfo.USE_PLATFORM));
						targetInfo.setUseCondition(rs.getString(TargetInfo.USE_CONDITION));
						targetInfo.setTargetCondInfo(targetCondInfo);
					}
					
					targetInfo.setAudienceSeq(rs.getInt(TargetInfo.AUDIENCE_SEQ));
				}
				
				targetInfo.setUseLogin(rs.getString(TargetInfo.USE_LOGIN));
				targetInfo.setMktYn(rs.getString(TargetInfo.MKT_YN));
				targetInfo.setEncryptYn(rs.getString(TargetInfo.ENCRYPT_YN));
				targetInfo.setSiteId(rs.getInt(TargetInfo.SITE_ID));
				targetInfo.setTargetCnt(rs.getInt(TargetInfo.TARGET_CNT));
				targetInfo.setAppGrpId(rs.getInt(TargetInfo.APP_GRP_ID));
				targetInfo.setWhereInfo(rs.getString(TargetInfo.WHERE_INFO))
					.setNextTarget(rs.getString(TargetInfo.NEXT_TARGET_YN))
					.setAbTestFileYn(rs.getString(TargetInfo.AB_TEST_YN))
					.setAddSiteUserYn(rs.getString(TargetInfo.ADD_SITE_USER_YN))
					.setFirstChannelType(rs.getString(TargetInfo.FIRST_CHANNEL_TYPE));
				targetInfo.setSeqNo(rs.getString(TargetInfo.SEQNO));
				return targetInfo;
			}
		}, msgId);
	}

	@Override
	public void beforeStep(StepExecution stepExecution) {
		this.stepExecution = stepExecution;
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		return stepExecution.getExitStatus();
	}
}