package com.humuson.tms.batch.job.tasklet;

import java.util.Map;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.PushInfoService;

@Slf4j
public class InitPushSendTasklet implements Tasklet {
	
	@Autowired
	protected JdbcTemplate jdbcTemplate;
	@Setter protected String selectMinMaxId;
	
	@Autowired PushInfoService<App, PushMessage> pushInfoServiceImpl;
	
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		final String appGrpKey = chunkContext.getStepContext()
				.getStepExecution().getJobParameters().getString(JobParamConstrants.APP_GRP_KEY);
		
		Map<String, Object> map = null;
		map = this.jdbcTemplate.queryForMap(this.selectMinMaxId, appGrpKey);
		
		long minId = 0;
		long maxId = 0;
		
		final int appGrpId =  pushInfoServiceImpl.getAppGrpIdByAppGrpKey(appGrpKey);
		
		if (map.get("MIN_ID") != null) {	
			minId = Long.parseLong(map.get("MIN_ID").toString());
			maxId = Long.parseLong(map.get("MAX_ID").toString());
		}
		if (log.isDebugEnabled()) log.debug("min :{}, max:{}", minId, maxId);
		
		chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putLong(JobExecutionContextConstrants.KEY_MIN_ID, minId);
		chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putLong(JobExecutionContextConstrants.KEY_MAX_ID, maxId);
		chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putLong(JobExecutionContextConstrants.KEY_APP_GRP_ID, appGrpId);
		
		return RepeatStatus.FINISHED;
	}
}