package com.humuson.tms.batch.job.tasklet;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.constrants.OptmzTargetType;

@Slf4j
public class InitOptmzManualChannelTasklet implements Tasklet, StepExecutionListener {
	
	private StepExecution stepExecution;

	@Setter
	private String deleteSendList, updateOptmzManualChannelInfo;
	@Setter
	private String fromClause, defaultWhereClause, successWhereClause, failWhereClause;
	@Setter
	private String openWhereClause, notOpenWhereClause, clickWhereClause, notClickWhereClause; 
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public RepeatStatus execute(StepContribution contribution,
			ChunkContext chunkContext) throws Exception {
		final String postId = stepExecution.getJobParameters().getString(JobParamConstrants.POST_ID);
//		final String pPostId = stepExecution.getJobParameters().getString(JobParamConstrants.P_POST_ID);
		final String optmzTargetType = stepExecution.getJobParameters().getString(JobParamConstrants.OPTMZ_TARGET_TYEPE);
		ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
		
		int count = 0, totalDeleteCount = 0;
		do {
			count = jdbcTemplate.update(deleteSendList, postId);
			totalDeleteCount += count;
			log.info("prev target date remove...[delete count:{}]", totalDeleteCount, count);
		} while (count > 0);
		
		// optmz manual channel target count 0
		jdbcTemplate.update(updateOptmzManualChannelInfo, postId);
		
		
		StringBuilder fromClauseBuilder = new StringBuilder();
		StringBuilder whereClauseBuilder = new StringBuilder();
		
		whereClauseBuilder.append(defaultWhereClause);
		fromClauseBuilder.append(fromClause);
			 
		if (OptmzTargetType.SUCCESS.getCode().equals(optmzTargetType)) {		// 이전 발송 성공 대상자
			whereClauseBuilder.append(successWhereClause);
		} else if (OptmzTargetType.FAIL.getCode().equals(optmzTargetType)) {	// 이전 발송 실패 대상자
			whereClauseBuilder.append(failWhereClause);
		} else if (OptmzTargetType.OPEN.getCode().equals(optmzTargetType)) {	// 이전 발송 오픈 대상자
			whereClauseBuilder.append(openWhereClause);
		} else if (OptmzTargetType.NOT_OPEN.getCode().equals(optmzTargetType) ) { 	// 이전 발송 미오픈 대상자
			whereClauseBuilder.append(notOpenWhereClause);
		} else if (OptmzTargetType.NOT_CLICK.getCode().equals(optmzTargetType) ) {	// 이전 발송 미클릭 대상자
			whereClauseBuilder.append(openWhereClause);
			whereClauseBuilder.append(notClickWhereClause);
		} else if (OptmzTargetType.CLICK.getCode().equals(optmzTargetType)) {	// 이전 발송 클릭 대상자
			whereClauseBuilder.append(clickWhereClause);
		}
		
		executionContext.put(JobExecutionContextConstrants.KEY_FROM_CLAUSE, fromClauseBuilder.toString());
		executionContext.put(JobExecutionContextConstrants.KEY_WHERE_CLAUSE, whereClauseBuilder.toString());
		
		log.info("jobExecutionContext [{}]", stepExecution.getJobExecution().getExecutionContext().toString());
		
		return RepeatStatus.FINISHED;
	}
	
	@Override
	public void beforeStep(StepExecution stepExecution) {
		this.stepExecution = stepExecution;
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		return stepExecution.getExitStatus();
	}
}
