package com.humuson.tms.batch.job.tasklet;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;
import com.humuson.tms.constrants.ChannelType;

@Slf4j
public class InitFileTargetingTasklet implements Tasklet, StepExecutionListener {
	
	private StepExecution stepExecution;
	
	@Override
	public RepeatStatus execute(StepContribution contribution,
			ChunkContext chunkContext) throws Exception {
		
		log.info("InitFileTargetingTasklet start");
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_POST_ID, "2016030100001");
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_CHN_TYPE, ChannelType.EMAIL.getCode());
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_SEND_LIST_TABLE, "tms_send_list_03");
		
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_CHARSET, "utf-8");
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_LINES_TO_SKIP, String.valueOf(1));
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_DELIMITER, ",");
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_HEADER, "TMS_M_ID,TMS_M_NAME,TMS_M_EMAIL,FIELD1,FIELD2,FIELD3,FIELD4,FIELD5,FIELD6,FIELD7,FIELD8");
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_SEND_LIST_TABLE, "tms_send_list_03");
		stepExecution.getJobExecution().getExecutionContext().put(JobExecutionContextConstrants.KEY_FILE_PATH, "/Users/hyogun/workspace/pms-work/tms-batch");
		if (log.isDebugEnabled())
			log.debug("jobExecutionContext [{}]", stepExecution.toString());
		
		return RepeatStatus.FINISHED;
	}

	@Override
	public void beforeStep(StepExecution stepExecution) {
		// TODO Auto-generated method stub
		this.stepExecution = stepExecution;
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		// TODO Auto-generated method stub
		return stepExecution.getExitStatus();
	}

}
