package com.humuson.tms.batch.job.tasklet;

import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.impl.FatigueFilterScheduleStatusUpdateService;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.constrants.StatusType;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class FatigueFilteredSchdlStatusUpdateTasklet implements Tasklet{
	
	@Autowired FatigueFilterScheduleStatusUpdateService fatigueFilterScheduleStatusUpdateService;
	
	@Override
	public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
		
		JobParameters jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters();
		
		String sendType = jobParameters.getString(JobParamConstrants.SEND_TYPE);
		
		FatigueFilterSchedule schedule = new FatigueFilterSchedule();
		schedule.setSendType(sendType);
		schedule.setPostId(jobParameters.getString(JobParamConstrants.POST_ID));
		schedule.setServerId(jobParameters.getString(JobParamConstrants.SERVER_ID));
		
		/*
		 * 대량 캠페인은 피로도 체크를 한 뒤 등록 작업을 진행하므로 job_status를 '62'로 변경
		 * 자동 캠페인은 이미 등록 작업이 완료된 상태이므로 job_status를 '20'으로 변경
		 */
		if (CommonType.MASS.getCode().equals(sendType)) {
			schedule.setJobStatus(StatusType.FATIGUE_FILTER_COMPLETE.getCode());
		} else {
			schedule.setJobStatus(StatusType.RESERVE.getCode());
		}
		
		fatigueFilterScheduleStatusUpdateService.updateSchdlStatus(schedule);

		return RepeatStatus.FINISHED;
	}
}
