package com.humuson.tms.batch.job.tasklet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import lombok.Setter;

/**
 * 하루에 한 번 더미 발송 건을 연동 테이블에 넣어 주는 Task(스타벅스 customizing)
 * 
 *
 */
public class DummySendInsertTasklet implements Tasklet {
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	@Setter private String insertDummySendData;
	
	Logger logger = LoggerFactory.getLogger(DummySendInsertTasklet.class);
		
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		logger.info("Insert dummy send data to TMS_QUEUE");
		jdbcTemplate.batchUpdate(insertDummySendData);
		
		return RepeatStatus.FINISHED;
		
	}
	
}
